/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpClientConnection;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpHost;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.config.ConnectionConfig;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.config.SocketConfig;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.pool.BasicConnFactory;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.pool.BasicPoolEntry;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.params.HttpParams;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.pool.AbstractConnPool;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.pool.ConnFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

