/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.converter;

import com.taskadapter.redmineapi.bean.Issue;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;

public final class SquashIssueFiller {
    private SquashIssueFiller() {
    }

    public static void fillSquashIssue(AdvancedIssue squashIssue, Issue redmineIssue, String issueTypeFieldId) {
        AdvancedProject projectStub = new AdvancedProject();
        projectStub.setId(redmineIssue.getProject().getIdentifier());
        projectStub.setName(redmineIssue.getProject().getName());
        squashIssue.setProject(projectStub);
        squashIssue.setId(redmineIssue.getId().toString());
        SquashIssueFiller.setIssueType(squashIssue, redmineIssue);
        SquashIssueFiller.setSummary(squashIssue, redmineIssue);
        SquashIssueFiller.setPriority(squashIssue, redmineIssue);
        SquashIssueFiller.setStatus(squashIssue, redmineIssue);
        SquashIssueFiller.setAssignee(squashIssue, redmineIssue);
        SquashIssueFiller.setDescription(squashIssue, redmineIssue);
        SquashIssueFiller.setCurrentScheme(squashIssue, redmineIssue, issueTypeFieldId);
    }

    private static void setIssueType(AdvancedIssue squashIssue, Issue redmineIssue) {
        if (redmineIssue.getTracker() != null) {
            squashIssue.setFieldValue("issuetype", new FieldValue("", redmineIssue.getTracker().getName()));
        }
    }

    private static void setSummary(AdvancedIssue squashIssue, Issue redmineIssue) {
        if (redmineIssue.getSubject() != null) {
            squashIssue.setFieldValue("summary", new FieldValue("", redmineIssue.getSubject()));
        }
    }

    private static void setDescription(AdvancedIssue squashIssue, Issue redmineIssue) {
        if (!StringUtils.isBlank((CharSequence)redmineIssue.getDescription())) {
            squashIssue.setFieldValue("description", new FieldValue("", redmineIssue.getDescription()));
        }
    }

    private static void setPriority(AdvancedIssue squashIssue, Issue redmineIssue) {
        if (redmineIssue.getPriorityText() != null) {
            String id = String.valueOf(redmineIssue.getPriorityId());
            String name = redmineIssue.getPriorityText();
            squashIssue.setFieldValue("priority", new FieldValue(id, name));
        }
    }

    private static void setStatus(AdvancedIssue squashIssue, Issue redmineIssue) {
        if (redmineIssue.getStatusName() != null) {
            squashIssue.setFieldValue("status", new FieldValue("", redmineIssue.getStatusName()));
        }
    }

    private static void setAssignee(AdvancedIssue squashIssue, Issue redmineIssue) {
        if (redmineIssue.getAssignee() != null) {
            String id = redmineIssue.getAssignee().getId().toString();
            String name = redmineIssue.getAssignee().getFullName();
            squashIssue.setFieldValue("assignee", new FieldValue(id, name));
        } else {
            squashIssue.setFieldValue("assignee", new FieldValue("", ""));
        }
    }

    private static void setCurrentScheme(AdvancedIssue squashIssue, Issue redmineIssue, String issueTypeFieldId) {
        squashIssue.setCurrentScheme(issueTypeFieldId + ":" + redmineIssue.getTracker().getName());
    }
}

