/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.converter;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Redmine3IssueBuilder {
    private Project project;
    private User author;
    private User assignee;
    private IssueCategory category;
    private Tracker tracker;
    private List<CustomField> customFields = new ArrayList<CustomField>();
    private String description;
    private Integer doneRatio;
    private Date dueDate;
    private Float estimatedTime;
    private Integer parentId;
    private Integer priorityId;
    private String subject;
    private Date startDate;
    private Version version;

    public Redmine3IssueBuilder(Project project, User author, Tracker tracker) {
        this.tracker = tracker;
        this.project = project;
        this.author = author;
    }

    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    public void setIssueCategory(IssueCategory category) {
        this.category = category;
    }

    public void addCustomField(CustomField customField) {
        this.customFields.add(customField);
    }

    public void setCategory(IssueCategory category) {
        this.category = category;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDoneRatio(Integer doneRatio) {
        this.doneRatio = doneRatio;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setEstimatedTime(Float estimatedTime) {
        this.estimatedTime = estimatedTime;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public void setPriorityId(Integer priorityId) {
        this.priorityId = priorityId;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Issue build() {
        Issue issue = new Issue();
        issue.setCreatedOn(new Date());
        issue.setProject(this.project);
        issue.setAssignee(this.assignee);
        issue.setAuthor(this.author);
        issue.setCategory(this.category);
        issue.setCustomFields(this.customFields);
        issue.setDescription(this.description);
        issue.setDoneRatio(this.doneRatio);
        issue.setDueDate(this.dueDate);
        issue.setEstimatedHours(this.estimatedTime);
        issue.setParentId(this.parentId);
        issue.setPriorityId(this.priorityId);
        issue.setSubject(this.subject);
        issue.setTracker(this.tracker);
        issue.setStartDate(this.startDate);
        issue.setTargetVersion(this.version);
        return issue;
    }
}

