/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.squashtest.csp.core.bugtracker.core.NamespacedBugtrackerMessageSource;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.plugin.bugtracker.redmine3.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.bugtracker.redmine3.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.bugtracker.redmine3.licensevalidator.service.impl.ValidationServiceImpl;

@Configuration
@ComponentScan(basePackages={"org.squashtest.tm.plugin.bugtracker.redmine3"})
public class Redmine3ConnectorConfig {
    @Inject
    private SquashPathProperties squashPathProperties;

    @Bean
    public MessageSource redmine3ConnectorMessageSource() {
        ReloadableResourceBundleMessageSource bean = new ReloadableResourceBundleMessageSource();
        bean.setCacheSeconds(60);
        bean.setBasenames(new String[]{"classpath:/org/squashtest/tm/plugin/bugtracker/redmine3/messages", this.squashPathProperties.getLanguagesPath() + "/plugin.bugtracker.redmine3/messages"});
        return new NamespacedBugtrackerMessageSource((MessageSource)bean, "bugtracker.redmine3.");
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.redmine3.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.redmine3.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.bugtracker.redmine3.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

