/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.comm;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineTransportException;
import com.taskadapter.redmineapi.internal.comm.BasicHttpResponse;
import com.taskadapter.redmineapi.internal.comm.ContentHandler;
import com.taskadapter.redmineapi.internal.comm.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpEntity;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpResponse;

final class TransportDecoder
implements ContentHandler<HttpResponse, BasicHttpResponse> {
    TransportDecoder() {
    }

    @Override
    public BasicHttpResponse processContent(HttpResponse content) throws RedmineException {
        HttpEntity entity = content.getEntity();
        if (entity == null) {
            return new BasicHttpResponse(content.getStatusLine().getStatusCode(), InputStream.nullInputStream(), StandardCharsets.UTF_8.name());
        }
        String charset = HttpUtil.getCharset(entity);
        String encoding = HttpUtil.getEntityEncoding(entity);
        try {
            InputStream initialStream = entity.getContent();
            return new BasicHttpResponse(content.getStatusLine().getStatusCode(), this.decodeStream(encoding, initialStream), charset);
        }
        catch (IOException var6) {
            throw new RedmineTransportException(var6);
        }
    }

    private InputStream decodeStream(String encoding, InputStream initialStream) throws IOException {
        if (encoding == null) {
            return initialStream;
        }
        if ("gzip".equals(encoding)) {
            return new GZIPInputStream(initialStream);
        }
        if ("deflate".equals(encoding)) {
            return new InflaterInputStream(initialStream);
        }
        throw new IOException("Unsupported transport encoding " + encoding);
    }
}

