/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.squashtest.tm.api.security.authentication.ConditionalOnAuthProviderProperty;
import org.squashtest.tm.plugin.security.ad.ldap.ActiveDirectoryLdapAuthenticationProperties;
import org.squashtest.tm.plugin.security.ad.ldap.ActiveDirectoryLdapAuthenticationProviderFactoryBean;
import org.squashtest.tm.plugin.security.ad.ldap.CaseAwareUserDetailsMapper;
import org.squashtest.tm.plugin.security.ad.ldap.MultiActiveDirectoryLdapAuthenticationProviderFeatures;
import org.squashtest.tm.plugin.security.ad.ldap.SquashActiveDirectoryLdapAuthenticationProvider;
import org.squashtest.tm.plugin.security.ad.ldap.UserDetailsServiceActiveDirectoryLdapAuthoritiesPopulator;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.security.UserDetailsService;
import org.squashtest.tm.service.user.UserManagerService;

@Configuration
@ConditionalOnAuthProviderProperty(value="ad.ldap-multi")
@EnableConfigurationProperties(value={ActiveDirectoryLdapAuthenticationProperties.class})
public class MultiActiveDirectoryLdapSecurityConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiActiveDirectoryLdapSecurityConfig.class);
    @Inject
    @Named(value="squashtest.core.security.JdbcUserDetailsManager")
    @Lazy
    private SquashUserDetailsManager userDetailsManager;
    @Inject
    @Named(value="caseAwareUserDetailsMapper.ad.ldap")
    private CaseAwareUserDetailsMapper userDetailsMapper;
    @Value(value="${authentication.ad.multi.root.names}")
    private String[] adRootNames;
    @Inject
    private Environment environment;
    @Inject
    @Lazy
    private UserManagerService userManagerService;

    @Configuration
    @ConditionalOnAuthProviderProperty(value="ad.ldap-multi")
    @Order(value=1)
    public class ActiveDirectoryLdapAuthenticationConfig
    extends GlobalAuthenticationConfigurerAdapter {
        private static final String SERVER_URL_KEY = "authentication.ad.server.url";
        private static final String SERVER_DOMAIN = "authentication.ad.server.domain";
        private static final String SERVER_MANAGER_DN_KEY = "authentication.ad.server.managerDn";
        private static final String SERVER_MANAGER_PASSWORD_KEY = "authentication.ad.server.managerPassword";
        private static final String USER_SEARCH_FILTER_KEY = "authentication.ad.user.searchFilter";
        private static final String USER_SEARCH_BASE_KEY = "authentication.ad.user.searchBase";

        public void init(AuthenticationManagerBuilder auth) throws Exception {
            LOGGER.info("Multi AD configuration is enabled - Begin configuration ");
            this.checkAdRootNames();
            String[] stringArray = MultiActiveDirectoryLdapSecurityConfig.this.adRootNames;
            int n = MultiActiveDirectoryLdapSecurityConfig.this.adRootNames.length;
            int n2 = 0;
            while (n2 < n) {
                String adRootName = stringArray[n2];
                LOGGER.info("Begin LDAP Configuration : " + adRootName);
                ActiveDirectoryLdapAuthenticationProperties adAuthenticationProperties = this.getPropertiesForOneAd(adRootName);
                DefaultSpringSecurityContextSource contextSource = this.createSpringSecurityContextSource(adAuthenticationProperties);
                ActiveDirectoryLdapAuthenticationProviderFactoryBean adAuthenticationProviderFactoryBean = this.createActiveDirectoryLdapAuthenticationProvider(adAuthenticationProperties, contextSource);
                SquashActiveDirectoryLdapAuthenticationProvider activeDirectoryLdapAuthenticationProvider = adAuthenticationProviderFactoryBean.getObject();
                auth.authenticationProvider((AuthenticationProvider)activeDirectoryLdapAuthenticationProvider);
                LOGGER.info("Ending LDAP Configuration : " + adRootName);
                ++n2;
            }
            auth.eraseCredentials(false);
        }

        @Bean
        public MultiActiveDirectoryLdapAuthenticationProviderFeatures multiActiveDirectoryLdapAuthenticationProviderFeatures() {
            return MultiActiveDirectoryLdapAuthenticationProviderFeatures.INSTANCE;
        }

        private DefaultSpringSecurityContextSource createSpringSecurityContextSource(ActiveDirectoryLdapAuthenticationProperties adAuthenticationProperties) throws Exception {
            ActiveDirectoryLdapAuthenticationProperties.Server server = adAuthenticationProperties.getServer();
            DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(server.getUrl());
            contextSource.setUserDn(server.getManagerDn());
            contextSource.setPassword(server.getManagerPassword());
            contextSource.afterPropertiesSet();
            return contextSource;
        }

        private ActiveDirectoryLdapAuthenticationProviderFactoryBean createActiveDirectoryLdapAuthenticationProvider(ActiveDirectoryLdapAuthenticationProperties authenticationProperties, DefaultSpringSecurityContextSource contextSource) throws Exception {
            ActiveDirectoryLdapAuthenticationProviderFactoryBean factoryBean = new ActiveDirectoryLdapAuthenticationProviderFactoryBean();
            factoryBean.setActiveAuthenticationProvider("ad.ldap-multi");
            factoryBean.setContextSource((LdapContextSource)contextSource);
            ActiveDirectoryLdapAuthenticationProperties.User user = authenticationProperties.getUser();
            factoryBean.setUserSearchBase(user.getSearchBase());
            factoryBean.setUserSearchFilter(user.getSearchFilter());
            ActiveDirectoryLdapAuthenticationProperties.Server server = authenticationProperties.getServer();
            factoryBean.setUrl(server.getUrl());
            factoryBean.setDomain(server.getDomain());
            factoryBean.setAuthoritiesPopulator(new UserDetailsServiceActiveDirectoryLdapAuthoritiesPopulator((UserDetailsService)MultiActiveDirectoryLdapSecurityConfig.this.userDetailsManager));
            factoryBean.setUserDetailsMapper(MultiActiveDirectoryLdapSecurityConfig.this.userDetailsMapper);
            factoryBean.setFeatures(this.multiActiveDirectoryLdapAuthenticationProviderFeatures());
            factoryBean.setUserManagerService(MultiActiveDirectoryLdapSecurityConfig.this.userManagerService);
            factoryBean.afterPropertiesSet();
            return factoryBean;
        }

        private void logConfigurationParameter(String ldapRootName, String rootKey, Object parameterValue) {
            if (parameterValue != null) {
                LOGGER.info("Loading conf for {}. Key: {}. Value in squash configuration: {}", new Object[]{ldapRootName, rootKey, parameterValue});
            } else {
                LOGGER.info("Loading conf for {}. Key: {}. Value in squash configuration is null. Default value will be used.", (Object)ldapRootName, (Object)rootKey);
            }
        }

        private <T> T getBaseNamedProperty(String ldapRootName, String propertyName, Class<T> type) {
            return (T)MultiActiveDirectoryLdapSecurityConfig.this.environment.getProperty(ldapRootName + "." + propertyName, type);
        }

        private void checkAdRootNames() {
            if (MultiActiveDirectoryLdapSecurityConfig.this.adRootNames == null || MultiActiveDirectoryLdapSecurityConfig.this.adRootNames.length == 0) {
                throw new IllegalArgumentException("The property authentication.ldap.multi.root.names is mandatory when using ldap plugin in multi ldap mode.");
            }
        }

        private ActiveDirectoryLdapAuthenticationProperties getPropertiesForOneAd(String adRootName) {
            ActiveDirectoryLdapAuthenticationProperties adAuthenticationProperties = new ActiveDirectoryLdapAuthenticationProperties();
            String serverUrl = this.getBaseNamedProperty(adRootName, SERVER_URL_KEY, String.class);
            this.logConfigurationParameter(adRootName, SERVER_URL_KEY, serverUrl);
            adAuthenticationProperties.getServer().setUrl(serverUrl);
            String managerDn = this.getBaseNamedProperty(adRootName, SERVER_MANAGER_DN_KEY, String.class);
            this.logConfigurationParameter(adRootName, SERVER_MANAGER_DN_KEY, managerDn);
            adAuthenticationProperties.getServer().setManagerDn(managerDn);
            String managerPassword = this.getBaseNamedProperty(adRootName, SERVER_MANAGER_PASSWORD_KEY, String.class);
            adAuthenticationProperties.getServer().setManagerPassword(managerPassword);
            String serverDomain = this.getBaseNamedProperty(adRootName, SERVER_DOMAIN, String.class);
            this.logConfigurationParameter(adRootName, SERVER_DOMAIN, serverDomain);
            adAuthenticationProperties.getServer().setDomain(serverDomain);
            String searchBase = this.getBaseNamedProperty(adRootName, USER_SEARCH_BASE_KEY, String.class);
            this.logConfigurationParameter(adRootName, USER_SEARCH_BASE_KEY, searchBase);
            adAuthenticationProperties.getUser().setSearchBase(searchBase);
            String searchFilter = this.getBaseNamedProperty(adRootName, USER_SEARCH_FILTER_KEY, String.class);
            this.logConfigurationParameter(adRootName, USER_SEARCH_FILTER_KEY, searchFilter);
            adAuthenticationProperties.getUser().setSearchFilter(searchFilter);
            return adAuthenticationProperties;
        }
    }
}

