/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.util.function.Supplier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils.RestTemplateFactory;

public abstract class RestTemplateAbstractFactory
implements RestTemplateFactory,
InitializingBean {
    @Inject
    protected RestTemplateBuilder builder;
    protected Supplier<ClientHttpRequestFactory> springRequestFactory;

    @Override
    public RestTemplate restTemplate(BugTracker bugTracker, BasicAuthenticationCredentials credentials) {
        String baseUrl = bugTracker.getUrl();
        return this.builder.basicAuthentication(credentials.getUsername(), String.valueOf(credentials.getPassword())).rootUri(baseUrl).requestFactory(this.springRequestFactory).messageConverters(new HttpMessageConverter[]{this.tuleapPluginMappingJackson2HttpMessageConverter()}).build();
    }

    protected abstract void initSpringRequestFactory();

    public void afterPropertiesSet() {
        this.initSpringRequestFactory();
    }

    public MappingJackson2HttpMessageConverter tuleapPluginMappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(this.tuleapPluginObjectMapper());
        return messageConverter;
    }

    public ObjectMapper tuleapPluginObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return objectMapper;
    }
}

