/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.TuleapClient;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapArtifact;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapArtifactCollection;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapFile;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapFileChunk;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapPatch;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapProject;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapTracker;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils.PathBuilder;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.utils.RestTemplateFactory;

@Component
@Scope(value="prototype")
public class TuleapClientImpl
implements TuleapClient {
    @Inject
    @Named(value="tuleapExceptionHandler")
    private ExceptionHandler exceptionHandler;
    @Inject
    private RestTemplateFactory restTemplateFactory;
    @Inject
    private ObjectMapper mapper;
    private RestTemplate restTemplate;

    @Override
    public void init(BugTracker bugTracker, Credentials credentials) {
        if (!AuthenticationProtocol.BASIC_AUTH.equals((Object)credentials.getImplementedProtocol())) {
            throw new IllegalArgumentException("Expected Basic Auth credentials.");
        }
        BasicAuthenticationCredentials basicAuthenticationCredentials = (BasicAuthenticationCredentials)credentials;
        this.checkEmptyCredentials(basicAuthenticationCredentials);
        this.restTemplate = this.restTemplateFactory.restTemplate(bugTracker, basicAuthenticationCredentials);
    }

    @Override
    public List<TuleapProject> fetchPaginatedTuleapProjects(int limit, int offset) {
        HttpEntity<?> entity = this.getHttpEntity();
        ParameterizedTypeReference<List<TuleapProject>> projects = new ParameterizedTypeReference<List<TuleapProject>>(){};
        String path = PathBuilder.buildRelativePath("projects");
        String paginatedPath = String.format("%s?limit=%d&offset=%d", path, limit, offset);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(paginatedPath, HttpMethod.GET, entity, (ParameterizedTypeReference)projects, new Object[0]);
            List currentPageProjects = (List)responseEntity.getBody();
            return currentPageProjects != null ? currentPageProjects : new ArrayList();
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    @Override
    public TuleapProject findProjectById(String projectId) {
        String path = PathBuilder.buildRelativePath("projects", projectId);
        TuleapProject tuleapProject = null;
        try {
            tuleapProject = (TuleapProject)this.restTemplate.getForObject(path, TuleapProject.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw this.exceptionHandler.genericError((Exception)((Object)e));
        }
        if (tuleapProject == null) {
            throw this.exceptionHandler.projectNotFound(projectId);
        }
        return tuleapProject;
    }

    @Override
    public List<TuleapTracker> findTrackers(TuleapProject tuleapProject) {
        HttpEntity<?> httpEntity = this.getHttpEntity();
        ParameterizedTypeReference<List<TuleapTracker>> trackers = new ParameterizedTypeReference<List<TuleapTracker>>(){};
        String path = PathBuilder.buildRelativePath(tuleapProject.getTrackersUri());
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(path, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)trackers, new Object[0]);
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    @Override
    public TuleapTracker findTracker(String id) {
        String path = PathBuilder.buildRelativePath("trackers", id);
        try {
            return (TuleapTracker)this.restTemplate.getForObject(path, TuleapTracker.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw this.exceptionHandler.genericError((Exception)((Object)e));
        }
    }

    @Override
    public TuleapArtifact findArtifactById(String id) {
        String path = PathBuilder.buildRelativePath("artifacts", id);
        try {
            return (TuleapArtifact)this.restTemplate.getForObject(path, TuleapArtifact.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw this.exceptionHandler.genericError((Exception)((Object)e));
        }
    }

    @Override
    public List<TuleapArtifact> findArtifactsByIds(List<String> ids) {
        int processed = 0;
        ArrayList<TuleapArtifact> artifacts = new ArrayList<TuleapArtifact>();
        while (processed < ids.size()) {
            int limit = Math.min(ids.size() - processed, 100);
            List<String> idChunk = ids.subList(processed, limit);
            String query = this.getQueryString(idChunk);
            String path = PathBuilder.buildRelativePath("artifacts");
            UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)path).queryParam("query={query}", new Object[0]).queryParam("limit={limit}", new Object[0]).queryParam("offset={offset}", new Object[0]);
            String url = builder.build().toUriString();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("query", query);
            params.put("limit", limit);
            params.put("offset", processed);
            HttpEntity<?> entity = this.getHttpEntity();
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, TuleapArtifactCollection.class, params);
            artifacts.addAll(((TuleapArtifactCollection)response.getBody()).getCollection());
            processed += limit;
        }
        return artifacts;
    }

    private String getQueryString(List<String> ids) {
        ObjectNode queryNode = this.mapper.createObjectNode();
        ArrayNode idsArray = this.mapper.createArrayNode();
        List filteredIds = ids.stream().distinct().collect(Collectors.toList());
        for (String id : filteredIds) {
            idsArray.add(Long.parseLong(id));
        }
        queryNode.putPOJO("id", (Object)idsArray);
        return queryNode.toString();
    }

    @Override
    public Optional<TuleapArtifact> findArtifactByIdFailSafe(String id) {
        String path = PathBuilder.buildRelativePath("artifacts", id);
        try {
            TuleapArtifact tuleapArtifact = (TuleapArtifact)this.restTemplate.getForObject(path, TuleapArtifact.class, new Object[0]);
            return Optional.of(tuleapArtifact);
        }
        catch (RestClientException restClientException) {
            return Optional.empty();
        }
    }

    @Override
    public void createArtifact(TuleapArtifact tuleapArtifact) {
        HttpEntity httpEntity = new HttpEntity((Object)tuleapArtifact, (MultiValueMap)this.getHttpHeaders());
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(PathBuilder.buildRelativePath("artifacts"), (Object)httpEntity, TuleapArtifact.class, new Object[0]);
            TuleapArtifact postedArtifactReference = (TuleapArtifact)responseEntity.getBody();
            tuleapArtifact.setId(postedArtifactReference.getId());
        }
        catch (Exception e) {
            throw this.exceptionHandler.genericError(e);
        }
    }

    @Override
    public Long createTemporaryFile(TuleapFile tuleapFile) {
        HttpEntity httpEntity = new HttpEntity((Object)tuleapFile, (MultiValueMap)this.getHttpHeaders());
        ResponseEntity responseEntity = this.restTemplate.postForEntity(PathBuilder.buildRelativePath("artifact_temporary_files"), (Object)httpEntity, TuleapFile.class, new Object[0]);
        TuleapFile postedFile = (TuleapFile)responseEntity.getBody();
        Long id = postedFile.getId();
        List<String> base64chunks = tuleapFile.getBase64chunks();
        IntStream.range(0, base64chunks.size()).forEach(index -> {
            TuleapFileChunk chunk = new TuleapFileChunk();
            chunk.setContent((String)base64chunks.get(index));
            chunk.setOffset(index + 2);
            this.restTemplate.put(PathBuilder.buildRelativePath("artifact_temporary_files", id.toString()), (Object)chunk, new Object[0]);
        });
        return id;
    }

    @Override
    public void patchArtifactForAttachments(String issueId, TuleapPatch tuleapPatch) {
        HttpEntity httpEntity = new HttpEntity((Object)tuleapPatch, (MultiValueMap)this.getHttpHeaders());
        String path = PathBuilder.buildRelativePath("artifacts", issueId);
        this.restTemplate.put(path, (Object)httpEntity, new Object[0]);
    }

    private void checkEmptyCredentials(BasicAuthenticationCredentials credentials) {
        if (credentials == null) {
            throw this.exceptionHandler.emptyCredentials();
        }
        String username = credentials.getUsername();
        String password = String.valueOf(credentials.getPassword());
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            throw this.exceptionHandler.emptyCredentials();
        }
    }

    private HttpEntity<?> getHttpEntity() {
        HttpHeaders headers = this.getHttpHeaders();
        return new HttpEntity((MultiValueMap)headers);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        return headers;
    }
}

