/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.squashtest.tm.plugin.report.books.requirements.beans.AttachReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.LowReq;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementVersion;

public class Requirement {
    private Long reqId;
    private boolean isFolder;
    private boolean isHlr;
    private Long level;
    private Long projectId;
    private String projectName;
    private Long numberOfVersions;
    private String highLevelReqLabel;
    private List<RequirementVersion> versions = new ArrayList<RequirementVersion>();
    private List<AttachReq> attachReqs;
    private List<LowReq> lowReqs;
    private String paragraph;
    private Long currentVersionId;
    private String currentVersionName;
    private String currentVersionRef;
    private boolean printMilestones;

    public boolean isHasHighLevelReq() {
        return !this.highLevelReqLabel.isEmpty();
    }

    public boolean isHasReference() {
        return !this.currentVersionRef.isEmpty();
    }

    public boolean isHasAttachReq() {
        return this.attachReqs != null;
    }

    public boolean isHasLowReq() {
        return this.lowReqs != null;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public void setParagraph(List<Integer> paragraphLevel) {
        this.paragraph = "";
        if (paragraphLevel != null && !paragraphLevel.isEmpty()) {
            Iterator<Integer> itr = paragraphLevel.iterator();
            String delimiter = "";
            while (itr.hasNext()) {
                this.paragraph = this.paragraph + delimiter + String.valueOf(itr.next());
                delimiter = ".";
            }
        }
    }

    public Long getReqId() {
        return this.reqId;
    }

    public void setReqId(Long reqId) {
        this.reqId = reqId;
    }

    public String getHighLevelReqLabel() {
        return this.highLevelReqLabel;
    }

    public void setHighLevelReqLabel(String highLevelReqLabel) {
        this.highLevelReqLabel = highLevelReqLabel;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setFolder(Long folder) {
        this.isFolder = folder == 1L;
    }

    public boolean isHlr() {
        return this.isHlr;
    }

    public void setHlr(Long hlr) {
        this.isHlr = hlr == 1L;
    }

    public Long getLevel() {
        return this.level;
    }

    public void setLevel(Long level) {
        this.level = level;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getNumberOfVersions() {
        return this.numberOfVersions;
    }

    public void setNumberOfVersions(Long numberOfVersions) {
        this.numberOfVersions = numberOfVersions;
    }

    public List<RequirementVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<RequirementVersion> versions) {
        this.versions = versions;
    }

    public List<AttachReq> getAttachReqs() {
        return this.attachReqs;
    }

    public void setAttachReqs(List<AttachReq> attachReqs) {
        this.attachReqs = attachReqs;
    }

    public List<LowReq> getLowReqs() {
        return this.lowReqs;
    }

    public void setLowReqs(List<LowReq> lowReqs) {
        this.lowReqs = lowReqs;
    }

    public Long getCurrentVersionId() {
        return this.currentVersionId;
    }

    public void setCurrentVersionId(Long currentVersionId) {
        this.currentVersionId = currentVersionId;
    }

    public String getCurrentVersionName() {
        return this.currentVersionName;
    }

    public void setCurrentVersionName(String currentVersionName) {
        this.currentVersionName = currentVersionName;
    }

    public String getCurrentVersionRef() {
        return this.currentVersionRef;
    }

    public void setCurrentVersionRef(String currentVersionRef) {
        this.currentVersionRef = currentVersionRef;
    }

    public void addLastVersion(RequirementVersion version) {
        this.versions.add(version);
    }

    public void addPreviousVersions(Collection<RequirementVersion> previousVersions) {
        this.versions.addAll(previousVersions);
    }

    public void orderVersions() {
        this.versions.sort((v1, v2) -> (int)(v1.getVersionNumber() - v2.getVersionNumber()));
    }

    public boolean isPrintMilestones() {
        return this.printMilestones;
    }

    public void setPrintMilestones(boolean printMilestones) {
        this.printMilestones = printMilestones;
    }
}

