/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service;

import bugzilla.org.apache.xmlrpc.XmlRpcException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.AbstractCacheService;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.CacheService;

public class RequestCacheServiceImpl
extends AbstractCacheService
implements CacheService {
    private final String bugTrackerUrl;
    private List<Map<String, Object>> allFields;
    private List<Map<String, Object>> customFields;
    private List<Map<String, Object>> nonCustomFields;

    public RequestCacheServiceImpl(String bugTrackerUrl) {
        this.bugTrackerUrl = bugTrackerUrl;
    }

    @Override
    public List<Map<String, Object>> getAllFields() throws BugzillaXmlrpcException {
        try {
            if (Objects.isNull(this.allFields)) {
                this.allFields = this.retrieveFields(this.bugTrackerUrl);
            }
            return this.allFields;
        }
        catch (XmlRpcException e) {
            throw new BugzillaXmlrpcException(e);
        }
    }

    @Override
    public List<Map<String, Object>> getNonCustomFields() throws BugzillaXmlrpcException {
        if (Objects.isNull(this.nonCustomFields)) {
            this.nonCustomFields = this.getAllFields().stream().filter(this::isFieldUseful).collect(Collectors.toList());
        }
        return this.nonCustomFields;
    }

    @Override
    public List<Map<String, Object>> getCustomFields() throws BugzillaXmlrpcException {
        if (Objects.isNull(this.customFields)) {
            this.customFields = this.getAllFields().stream().filter(this::isFieldCustom).collect(Collectors.toList());
        }
        return this.customFields;
    }
}

