/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter.BugzillaFieldType;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter.BugzillaFieldValueCreator;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaFieldInfo;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaFieldSchema;

@Component
public class BugzillaEntityMapping {
    private static final String EMPTY_VALUE = "interface.widget.none";
    private static final String STR_TARGET_MILESTONE = "target_milestone";
    private static final String STR_NOVALUE = "---";
    @Inject
    private BugzillaFieldValueCreator bugzillaFieldValueCreator;
    @Inject
    @Named(value="bugzillaConnectorMessageSource")
    private MessageSource messageSource;

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public boolean shouldDismissField(BugzillaFieldInfo fieldInfo) {
        boolean shouldDismiss = false;
        String fieldId = fieldInfo.getId();
        if (fieldId.equals(STR_TARGET_MILESTONE)) {
            boolean hasNoValue = true;
            boolean required = fieldInfo.isRequired();
            Iterator<Object> iter = fieldInfo.getAllowedValues().iterator();
            if (iter.hasNext()) {
                String value = iter.next().toString();
                hasNoValue = !iter.hasNext() && value.equals(STR_NOVALUE);
            }
            shouldDismiss = !required && hasNoValue;
        }
        return shouldDismiss;
    }

    public List<FieldValue> createFieldValues(BugzillaFieldInfo fieldInfo) {
        if (fieldInfo.getAllowedValues() == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        BugzillaFieldSchema schema = fieldInfo.getSchema();
        String itemType = schema.getItemType();
        for (Object aValue : fieldInfo.getAllowedValues()) {
            FieldValue newValue = this.bugzillaFieldValueCreator.createFieldValue(itemType, aValue);
            values.add(newValue);
        }
        if (!fieldInfo.isRequired() && this.needsEmptyValue(schema)) {
            this.addEmptyValue(values);
        }
        return values;
    }

    private boolean needsEmptyValue(BugzillaFieldSchema schema) {
        boolean result = true;
        BugzillaFieldType type = BugzillaFieldType.fromString(schema.getType());
        switch (type) {
            case MULTIPLE_SELECTION_BOX: {
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private void addEmptyValue(List<FieldValue> values) {
        FieldValue fieldValue = new FieldValue();
        fieldValue.setId("-1");
        fieldValue.setScalar(this.messageSource.getMessage(EMPTY_VALUE, null, this.getLocale()));
        fieldValue.setTypename("string");
        values.add(fieldValue);
    }
}

