/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.BugzillaConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;

@Service(value="squashtest.core.bugtracker.BugzillaConnectorProvider")
public class BugzillaConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    private static final String KIND = "bugzilla";
    private static final String LABEL = "Bugzilla connector";
    @Inject
    private Provider<BugzillaConnector> connectorProvider;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullPointerException("bugTracker");
        }
        BugzillaConnector connector = (BugzillaConnector)this.connectorProvider.get();
        connector.setBugTracker(bugTracker);
        return connector;
    }
}

