/*
 * Decompiled with CFR 0.152.
 */
package bugzilla.org.apache.xmlrpc.parser;

import bugzilla.org.apache.xmlrpc.XmlRpcException;
import bugzilla.org.apache.xmlrpc.parser.ByteArrayParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SerializableParser
extends ByteArrayParser {
    public Object getResult() throws XmlRpcException {
        if (!"1".equals(System.getProperty("bugzilla.org.apache.xmlrpc.allowInsecureDeserialization"))) {
            throw new UnsupportedOperationException("Deserialization of ex:serializable objects is vulnerable to remote execution attacks and is disabled by default. If you are sure the source data is trusted, you can enable it by setting org.apache.xmlrpc.allowInsecureDeserialization JVM property to 1");
        }
        try {
            byte[] res = (byte[])super.getResult();
            ByteArrayInputStream bais = new ByteArrayInputStream(res);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to read result object: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new XmlRpcException("Failed to load class for result object: " + e.getMessage(), e);
        }
    }
}

