/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsBugTrackerAndPath;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsCachedValues;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsCompositeCacheKey;

public class AzureDevopsValueCacheQueue {
    private final List<AzureDevopsBugTrackerAndPath> azureDevopsBugTrackerAndPaths = new ArrayList<AzureDevopsBugTrackerAndPath>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.azureDevopsBugTrackerAndPaths.size();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(AzureDevopsBugTrackerAndPath azureDevopsBugTrackerAndPath) {
        Object object = this.lock;
        synchronized (object) {
            return this.azureDevopsBugTrackerAndPaths.contains(azureDevopsBugTrackerAndPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(AzureDevopsBugTrackerAndPath azureDevopsBugTrackerAndPath, Map<AzureDevopsCompositeCacheKey, AzureDevopsCachedValues> cacheMap) {
        Object object = this.lock;
        synchronized (object) {
            if (this.azureDevopsBugTrackerAndPaths.contains(azureDevopsBugTrackerAndPath)) {
                return;
            }
            this.azureDevopsBugTrackerAndPaths.add(azureDevopsBugTrackerAndPath);
            this.orderByPriority(cacheMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureDevopsBugTrackerAndPath poll() {
        Object object = this.lock;
        synchronized (object) {
            if (this.azureDevopsBugTrackerAndPaths.isEmpty()) {
                return null;
            }
            return this.azureDevopsBugTrackerAndPaths.remove(0);
        }
    }

    private void orderByPriority(Map<AzureDevopsCompositeCacheKey, AzureDevopsCachedValues> cacheMap) {
        this.azureDevopsBugTrackerAndPaths.sort(Comparator.comparingInt(o -> {
            AzureDevopsCachedValues azureDevopsCachedValues = (AzureDevopsCachedValues)cacheMap.get(new AzureDevopsCompositeCacheKey(o.bugTracker().getId(), o.path()));
            if (azureDevopsCachedValues == null) {
                return 1;
            }
            return azureDevopsCachedValues.hasCacheError() ? 0 : 2;
        }));
    }
}

