/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain.execplan;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.NullComparator;
import org.joda.time.DateTime;

public final class ProjectReleases
implements Comparable<ProjectReleases> {
    private String project;
    @JsonDeserialize(contentAs=Release.class)
    private List<Release> releases = new ArrayList<Release>();

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public List<Release> getReleases() {
        Collections.sort(this.releases);
        return this.releases;
    }

    public void setReleases(List<Release> releases) {
        this.releases = releases;
    }

    public void addAll(List<Release> releases) {
        this.releases.addAll(releases);
    }

    @Override
    public int compareTo(ProjectReleases other) {
        return this.project.compareTo(other.getProject());
    }

    public String log() {
        return "project : '" + this.project + "', versions : " + String.valueOf(this.releases.stream().map(Release::getName).collect(Collectors.toList()));
    }

    public static final class Release
    implements Comparable<Release> {
        private static final NullComparator NULL_DATE_CMP = new NullComparator(true);
        private long id;
        private String name;
        private Date releaseDate;

        public Release() {
        }

        public Release(long id, String name, DateTime releaseDate) {
            this.id = id;
            this.name = name;
            if (releaseDate != null) {
                this.releaseDate = releaseDate.toDate();
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public void setReleaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
        }

        public void jodaReleaseDate(DateTime releaseDate) {
            this.releaseDate = releaseDate != null ? releaseDate.toDate() : null;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Override
        public int compareTo(Release other) {
            int cmp = NULL_DATE_CMP.compare((Object)this.releaseDate, (Object)other.releaseDate);
            if (cmp == 0 && this.name != null) {
                cmp = this.name.compareTo(other.name);
            }
            if (cmp == 0) {
                cmp = this.id < other.id ? -1 : 1;
            }
            return cmp;
        }
    }
}

