/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ldap;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.squashtest.tm.core.foundation.lang.ArrayUtils;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.plugin.security.ldap.AbstractLdapAuthenticationProviderFeatures;
import org.squashtest.tm.plugin.security.ldap.BlindBindAuthenticator;
import org.squashtest.tm.plugin.security.ldap.SquashLdapAuthenticationProvider;
import org.squashtest.tm.service.user.UserManagerService;

public class LdapAuthenticationProviderFactoryBean
implements FactoryBean<SquashLdapAuthenticationProvider>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAuthenticationProviderFactoryBean.class);
    private static final String LDAP_PROVIDER = "ldap";
    private static final String MULTI_LDAP_PROVIDER = "ldap-multi";
    private String[] userDnPatterns;
    private String userSearchBase;
    private String userSearchFilter;
    private LdapContextSource contextSource;
    private UserDetailsContextMapper userDetailsMapper;
    private String activeAuthenticationProvider;
    private LdapAuthoritiesPopulator authoritiesPopulator;
    private SquashLdapAuthenticationProvider authenticationProvider;
    private boolean fetchUserAttributes = true;
    private AbstractLdapAuthenticationProviderFeatures features;
    private UserManagerService userManagerService;

    public SquashLdapAuthenticationProvider getObject() {
        return this.authenticationProvider;
    }

    private SquashLdapAuthenticationProvider createAuthenticationProvider() throws Exception {
        LdapAuthenticator bindAuthenticator = this.createAuthenticator();
        SquashLdapAuthenticationProvider provider = new SquashLdapAuthenticationProvider(bindAuthenticator, this.authoritiesPopulator);
        provider.setUserDetailsContextMapper(this.userDetailsMapper);
        provider.setFeatures(this.features);
        provider.setUserFinder(this.userManagerService);
        return provider;
    }

    private LdapAuthenticator createAuthenticator() throws Exception {
        BlindBindAuthenticator bindAuthenticator;
        if (!this.fetchUserAttributes) {
            bindAuthenticator = new BlindBindAuthenticator((BaseLdapPathContextSource)this.contextSource);
            LOGGER.debug("No user attributes will be fetched upon successful bind");
        } else {
            bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)this.contextSource);
            LOGGER.debug("User attributes will be fetched upon successful bind");
        }
        if (this.hasUserDnPatterns()) {
            LOGGER.debug("Will resolve authentication using dn patterns");
            bindAuthenticator.setUserDnPatterns(this.userDnPatterns);
        }
        if (this.hasUserSearchConfig()) {
            LOGGER.debug("Will resolve authentication using a search filter");
            LdapUserSearch userSearch = this.createUserSearch();
            bindAuthenticator.setUserSearch(userSearch);
        }
        bindAuthenticator.afterPropertiesSet();
        return bindAuthenticator;
    }

    private boolean hasUserSearchConfig() {
        return !this.noUserSearchConfig();
    }

    private boolean hasUserDnPatterns() {
        return !this.noUserDnPatterns();
    }

    private LdapUserSearch createUserSearch() {
        String searchBase = this.userSearchBase == null ? "" : this.userSearchBase;
        String searchFilter = this.userSearchFilter == null ? "" : this.userSearchFilter;
        return new FilterBasedLdapUserSearch(searchBase, searchFilter, (BaseLdapPathContextSource)this.contextSource);
    }

    public Class<?> getObjectType() {
        return LdapAuthenticationProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setUserDnPatterns(String[] userDnPatterns) {
        this.userDnPatterns = userDnPatterns;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.userDetailsMapper == null) {
            LOGGER.warn("No UserDetailsMapper was configured. This may be a programming error");
        }
        if (LDAP_PROVIDER.equals(this.activeAuthenticationProvider) || MULTI_LDAP_PROVIDER.equals(this.activeAuthenticationProvider)) {
            LOGGER.info("Active auth provider is '{}', this factory will produce a  LDAP auth provider", (Object)this.activeAuthenticationProvider);
            this.initializeLdapAuthenticationProvider();
        } else {
            LOGGER.info("Active auth provider is '{}', this factory will produce a null auth provider", (Object)this.activeAuthenticationProvider);
            this.initializeNullAuthenticationProvider();
        }
    }

    private void initializeLdapAuthenticationProvider() throws Exception {
        Assert.propertyNotNull((Object)this.contextSource, (String)"contextSource");
        Assert.propertyNotNull((Object)this.authoritiesPopulator, (String)"authoritiesPopulator");
        LOGGER.info("Checking LdapAuthenticationManagerFactoryBean configuration");
        LOGGER.info("Configured user dn patterns : {}", (Object[])this.userDnPatterns);
        LOGGER.info("Configured user search base : {}", (Object)this.userSearchBase);
        LOGGER.info("Configured user search filter : {}", (Object)this.userSearchFilter);
        LOGGER.info("Configured 'fetch user attributes' flag : {}", (Object)this.fetchUserAttributes);
        if (this.noUserDnPatterns() && this.noUserSearchConfig()) {
            LOGGER.error("Wrong LDAP Provider configuration");
            throw new IllegalStateException("Either one should be configured : user dn pattern or user search base and search filter");
        }
        this.authenticationProvider = this.createAuthenticationProvider();
    }

    private void initializeNullAuthenticationProvider() {
        this.authenticationProvider = new NullAuthenticationProvider();
    }

    private boolean noUserSearchConfig() {
        return StringUtils.isEmpty((String)this.userSearchFilter);
    }

    private boolean noUserDnPatterns() {
        return ArrayUtils.isBlankStringsArray((String[])this.userDnPatterns);
    }

    public void setContextSource(LdapContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public void setActiveAuthenticationProvider(String activeAuthenticationProvider) {
        this.activeAuthenticationProvider = activeAuthenticationProvider;
    }

    public void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        this.authoritiesPopulator = authoritiesPopulator;
    }

    public void setFetchUserAttributes(boolean fetchAttributes) {
        this.fetchUserAttributes = fetchAttributes;
    }

    public void setUserDetailsMapper(UserDetailsContextMapper userDetailsMapper) {
        this.userDetailsMapper = userDetailsMapper;
    }

    public void setFeatures(AbstractLdapAuthenticationProviderFeatures features) {
        this.features = features;
    }

    public void setUserManagerService(UserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    private static class NullAuthenticationProvider
    extends SquashLdapAuthenticationProvider {
        public NullAuthenticationProvider() {
            super(new NullLdapAuthenticator());
        }

        @Override
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            return null;
        }

        public boolean supports(Class<? extends Object> authentication) {
            return false;
        }
    }

    private static class NullLdapAuthenticator
    implements LdapAuthenticator {
        private NullLdapAuthenticator() {
        }

        public DirContextOperations authenticate(Authentication authentication) {
            return null;
        }
    }
}

