/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.mantisissue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Category;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Field;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Issue;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.IssueCustomField;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Priority;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.ProjectCustomField;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Reproducibility;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Severity;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Tag;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.User;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Version;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.ViewState;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.mantisissue.customfields.converter.FieldValueSetter;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.mantisissue.customfields.converter.factory.FieldValueSetterFactory;

public class SquashToMantisIssueConverter {
    private static final FieldValueSetterFactory factory = new FieldValueSetterFactory();

    public static Issue convert(AdvancedIssue advancedIssue, Project project) {
        Issue issue = new Issue();
        issue.setProject(project);
        issue.setCategory(new Category(SquashToMantisIssueConverter.extractCategory(advancedIssue)));
        issue.setSeverity(new Severity(SquashToMantisIssueConverter.extractSeverity(advancedIssue)));
        issue.setHandler(new User(SquashToMantisIssueConverter.extractAssignee(advancedIssue)));
        issue.setSummary(SquashToMantisIssueConverter.extractSummary(advancedIssue));
        issue.setDescription(SquashToMantisIssueConverter.extractDescription(advancedIssue));
        issue.setAdditionalInformation(SquashToMantisIssueConverter.extractAdditionalInformation(advancedIssue));
        issue.setPriority(new Priority(SquashToMantisIssueConverter.extractPriority(advancedIssue)));
        issue.setReproducibility(new Reproducibility(SquashToMantisIssueConverter.extractReproducibility(advancedIssue)));
        issue.setStepsToReproduce(SquashToMantisIssueConverter.extractStepsToReproduce(advancedIssue));
        issue.setVisibility(new ViewState(SquashToMantisIssueConverter.extractVisibility(advancedIssue)));
        issue.setTags(SquashToMantisIssueConverter.extractTags(advancedIssue));
        issue.setCustomFields(SquashToMantisIssueConverter.extractCUF(advancedIssue, project.getCustomFields()));
        FieldValue versionFieldValue = SquashToMantisIssueConverter.extractVersionFieldValue(advancedIssue);
        if (!versionFieldValue.getId().equals("none")) {
            issue.setVersion(new Version(versionFieldValue.getScalar()));
        }
        return issue;
    }

    private SquashToMantisIssueConverter() {
    }

    private static String extractCategory(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("category").getScalar();
    }

    private static String extractSeverity(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("severity").getId();
    }

    private static String extractAssignee(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("assignee").getScalar();
    }

    private static String extractSummary(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("summary").getScalar();
    }

    private static String extractDescription(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("description").getScalar();
    }

    private static String extractAdditionalInformation(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("additionalInformation").getScalar();
    }

    private static FieldValue extractVersionFieldValue(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("version");
    }

    private static String extractPriority(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("priority").getId();
    }

    private static String extractReproducibility(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("reproducibility").getId();
    }

    private static String extractStepsToReproduce(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("stepsToReproduce").getScalar();
    }

    private static String extractVisibility(AdvancedIssue advancedIssue) {
        return advancedIssue.getFieldValue("viewState").getScalar().equals("true") ? "public" : "private";
    }

    private static List<Tag> extractTags(AdvancedIssue advancedIssue) {
        FieldValue[] response = advancedIssue.getFieldValue("tags").getComposite();
        return Arrays.stream(response).map(fieldValue -> new Tag(fieldValue.getScalar())).collect(Collectors.toList());
    }

    private static List<IssueCustomField> extractCUF(AdvancedIssue advancedIssue, List<ProjectCustomField> customFields) {
        ArrayList<IssueCustomField> result = new ArrayList<IssueCustomField>();
        customFields.forEach(field -> {
            FieldValue fieldValue = advancedIssue.getFieldValue(field.getName());
            FieldValueSetter setter = factory.get(field.getType());
            setter.set(fieldValue);
            result.add(new IssueCustomField(new Field(field.getName()), fieldValue.getScalar()));
        });
        return result;
    }
}

