/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.json;

import java.util.ArrayList;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.org.codehaus.jettison.json.JSONArray;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.BasicEntity;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.JR7EpicLinkPickerList;

public class JR7EpicLinkPickerListJsonParser
implements JsonObjectParser<JR7EpicLinkPickerList> {
    @Override
    public JR7EpicLinkPickerList parse(JSONObject json) throws JSONException {
        if (json == null) {
            return null;
        }
        JSONArray jsEpicLists = json.getJSONArray("epicLists");
        ArrayList<JR7EpicLinkPickerList.EpicList> epicLists = new ArrayList<JR7EpicLinkPickerList.EpicList>(jsEpicLists.length());
        int i = 0;
        while (i < jsEpicLists.length()) {
            JSONObject epicList = jsEpicLists.getJSONObject(i);
            if (epicList != null) {
                JR7EpicLinkPickerList.EpicList elist = this.parseList(epicList);
                epicLists.add(elist);
            }
            ++i;
        }
        int total = json.getInt("total");
        return new JR7EpicLinkPickerList(epicLists, total);
    }

    private JR7EpicLinkPickerList.EpicList parseList(JSONObject jsList) throws JSONException {
        JSONArray jsEpicNames = jsList.getJSONArray("epicNames");
        ArrayList<BasicEntity> epicNames = new ArrayList<BasicEntity>(jsEpicNames.length());
        int i = 0;
        while (i < jsEpicNames.length()) {
            JSONObject obj = jsEpicNames.getJSONObject(i);
            if (obj != null) {
                String key = obj.getString("key");
                String name = obj.getString("name");
                epicNames.add(new BasicEntity(key, name));
            }
            ++i;
        }
        String listDescriptor = jsList.getString("listDescriptor");
        return new JR7EpicLinkPickerList.EpicList(listDescriptor, epicNames);
    }
}

