/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.impl.io;

import jirarest.org.apache.http.HttpRequest;
import jirarest.org.apache.http.HttpRequestFactory;
import jirarest.org.apache.http.annotation.Contract;
import jirarest.org.apache.http.annotation.ThreadingBehavior;
import jirarest.org.apache.http.config.MessageConstraints;
import jirarest.org.apache.http.impl.DefaultHttpRequestFactory;
import jirarest.org.apache.http.impl.io.DefaultHttpRequestParser;
import jirarest.org.apache.http.io.HttpMessageParser;
import jirarest.org.apache.http.io.HttpMessageParserFactory;
import jirarest.org.apache.http.io.SessionInputBuffer;
import jirarest.org.apache.http.message.BasicLineParser;
import jirarest.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

