/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import java.util.regex.Pattern;
import jirarest.com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import jirarest.com.atlassian.httpclient.api.HttpClient;
import jirarest.com.atlassian.httpclient.api.Request;
import jirarest.com.atlassian.httpclient.api.ResponsePromise;
import jirarest.com.atlassian.httpclient.api.ResponseTransformation;
import jirarest.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jirarest.com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;

public abstract class AtlassianHttpClientDecorator
implements DisposableHttpClient {
    private final HttpClient httpClient;
    private final AuthenticationHandler authenticationHandler;

    public AtlassianHttpClientDecorator(HttpClient httpClient, AuthenticationHandler authenticationHandler) {
        this.httpClient = httpClient;
        this.authenticationHandler = authenticationHandler;
    }

    @Override
    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpClient.flushCacheByUriPattern(urlPattern);
    }

    @Override
    public Request.Builder newRequest() {
        return new AuthenticatedRequestBuilder();
    }

    @Override
    public Request.Builder newRequest(URI uri) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(uri);
        return builder;
    }

    @Override
    public Request.Builder newRequest(URI uri, String contentType, String entity) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(uri);
        builder.setContentType(contentType);
        builder.setEntity(entity);
        return builder;
    }

    @Override
    public Request.Builder newRequest(String uri) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(URI.create(uri));
        return builder;
    }

    @Override
    public Request.Builder newRequest(String uri, String contentType, String entity) {
        AuthenticatedRequestBuilder builder = new AuthenticatedRequestBuilder();
        builder.setUri(URI.create(uri));
        builder.setContentType(contentType);
        builder.setEntity(entity);
        return builder;
    }

    @Override
    public <A> ResponseTransformation.Builder<A> transformation() {
        return this.httpClient.transformation();
    }

    @Override
    public ResponsePromise execute(Request request) {
        return this.httpClient.execute(request);
    }

    private class AuthenticatedRequestBuilder
    extends DefaultRequest.DefaultRequestBuilder {
        public AuthenticatedRequestBuilder() {
            super(AtlassianHttpClientDecorator.this.httpClient);
        }

        @Override
        public ResponsePromise execute(Request.Method method) {
            if (AtlassianHttpClientDecorator.this.authenticationHandler != null) {
                this.setMethod(method);
                AtlassianHttpClientDecorator.this.authenticationHandler.configure(this);
            }
            return super.execute(method);
        }
    }
}

