/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import jirarest.com.atlassian.httpclient.api.HttpClient;
import jirarest.com.atlassian.jira.rest.client.api.VersionRestClient;
import jirarest.com.atlassian.jira.rest.client.api.domain.Version;
import jirarest.com.atlassian.jira.rest.client.api.domain.VersionRelatedIssuesCount;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.VersionInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.VersionPosition;
import jirarest.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.VersionRelatedIssueCountJsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import jirarest.com.atlassian.jira.rest.client.internal.json.gen.VersionInputJsonGenerator;
import jirarest.com.atlassian.jira.rest.client.internal.json.gen.VersionPositionInputGenerator;
import jirarest.com.sun.ws.rs.core.UriBuilder;
import jirarest.io.atlassian.util.concurrent.Promise;
import jirarest.javax.annotation.Nullable;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;

public class AsynchronousVersionRestClient
extends AbstractAsynchronousRestClient
implements VersionRestClient {
    private final URI versionRootUri;

    public AsynchronousVersionRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.versionRootUri = UriBuilder.fromUri(baseUri).path("version").build(new Object[0]);
    }

    @Override
    public Promise<Version> getVersion(URI versionUri) {
        return this.getAndParse(versionUri, new VersionJsonParser());
    }

    @Override
    public Promise<Version> createVersion(VersionInput versionInput) {
        return this.postAndParse(this.versionRootUri, versionInput, new VersionInputJsonGenerator(), new VersionJsonParser());
    }

    @Override
    public Promise<Version> updateVersion(URI versionUri, VersionInput versionInput) {
        return this.putAndParse(versionUri, versionInput, new VersionInputJsonGenerator(), new VersionJsonParser());
    }

    @Override
    public Promise<Void> removeVersion(URI versionUri, @Nullable URI moveFixIssuesToVersionUri, @Nullable URI moveAffectedIssuesToVersionUri) {
        UriBuilder uriBuilder = UriBuilder.fromUri(versionUri);
        if (moveFixIssuesToVersionUri != null) {
            uriBuilder.queryParam("moveFixIssuesTo", moveFixIssuesToVersionUri);
        }
        if (moveAffectedIssuesToVersionUri != null) {
            uriBuilder.queryParam("moveAffectedIssuesTo", moveAffectedIssuesToVersionUri);
        }
        return this.delete(uriBuilder.build(new Object[0]));
    }

    @Override
    public Promise<VersionRelatedIssuesCount> getVersionRelatedIssuesCount(URI versionUri) {
        URI relatedIssueCountsUri = UriBuilder.fromUri(versionUri).path("relatedIssueCounts").build(new Object[0]);
        return this.getAndParse(relatedIssueCountsUri, new VersionRelatedIssueCountJsonParser());
    }

    @Override
    public Promise<Integer> getNumUnresolvedIssues(URI versionUri) {
        URI unresolvedIssueCountUri = UriBuilder.fromUri(versionUri).path("unresolvedIssueCount").build(new Object[0]);
        return this.getAndParse(unresolvedIssueCountUri, new JsonObjectParser<Integer>(){

            @Override
            public Integer parse(JSONObject json) throws JSONException {
                return json.getInt("issuesUnresolvedCount");
            }
        });
    }

    @Override
    public Promise<Version> moveVersionAfter(URI versionUri, URI afterVersionUri) {
        URI moveUri = this.getMoveVersionUri(versionUri);
        return this.postAndParse(moveUri, afterVersionUri, new JsonGenerator<URI>(){

            @Override
            public JSONObject generate(URI uri) throws JSONException {
                JSONObject res = new JSONObject();
                res.put("after", uri);
                return res;
            }
        }, new VersionJsonParser());
    }

    @Override
    public Promise<Version> moveVersion(URI versionUri, VersionPosition versionPosition) {
        URI moveUri = this.getMoveVersionUri(versionUri);
        return this.postAndParse(moveUri, versionPosition, new VersionPositionInputGenerator(), new VersionJsonParser());
    }

    private URI getMoveVersionUri(URI versionUri) {
        return UriBuilder.fromUri(versionUri).path("move").build(new Object[0]);
    }
}

