/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.api.domain;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import jirarest.com.atlassian.jira.rest.client.api.AddressableEntity;
import jirarest.com.atlassian.jira.rest.client.api.IdentifiableEntity;
import jirarest.com.atlassian.jira.rest.client.api.NamedEntity;
import jirarest.com.atlassian.jira.rest.client.api.domain.Attachment;

public class EntityHelper {
    public static Function<IdentifiableEntity<String>, String> GET_ENTITY_STRING_ID_FUNCTION = new Function<IdentifiableEntity<String>, String>(){

        public String apply(IdentifiableEntity<String> entity) {
            return entity.getId();
        }
    };
    public static Function<NamedEntity, String> GET_ENTITY_NAME_FUNCTION = new Function<NamedEntity, String>(){

        public String apply(NamedEntity entity) {
            return entity.getName();
        }
    };

    public static Iterable<String> toNamesList(Iterable<? extends NamedEntity> items) {
        return Iterables.transform(items, GET_ENTITY_NAME_FUNCTION);
    }

    public static Iterable<String> toFileNamesList(Iterable<? extends Attachment> attachments) {
        return Iterables.transform(attachments, (Function)new Function<Attachment, String>(){

            public String apply(Attachment a) {
                return a.getFilename();
            }
        });
    }

    public static <T> Iterable<String> toStringIdList(Iterable<IdentifiableEntity<T>> items) {
        return Iterables.transform(items, (Function)new Function<IdentifiableEntity<T>, String>(){

            public String apply(IdentifiableEntity<T> from) {
                return from.getId() == null ? null : from.getId().toString();
            }
        });
    }

    public static <T extends NamedEntity> T findEntityByName(Iterable<T> entities, String name) {
        try {
            return (T)((NamedEntity)Iterables.find(entities, HasNamePredicate.forName(name)));
        }
        catch (NoSuchElementException ex) {
            throw new NoSuchElementException(String.format("Entity with name \"%s\" not found. Entities: %s", name, entities.toString()));
        }
    }

    public static <T extends IdentifiableEntity<K>, K> T findEntityById(Iterable<T> entities, K id) {
        try {
            return (T)((IdentifiableEntity)Iterables.find(entities, HasIdPredicate.forId(id)));
        }
        catch (NoSuchElementException ex) {
            throw new NoSuchElementException(String.format("Entity with id \"%s\" not found. Entities: %s", id, entities.toString()));
        }
    }

    public static <T extends Attachment> T findAttachmentByFileName(Iterable<T> attachments, String fileName) {
        return (T)((Attachment)Iterables.find(attachments, HasFileNamePredicate.forFileName(fileName)));
    }

    public static class AddressEndsWithPredicate
    implements Predicate<AddressableEntity> {
        private final String stringEnding;

        public AddressEndsWithPredicate(String stringEnding) {
            this.stringEnding = stringEnding;
        }

        public boolean apply(AddressableEntity input) {
            return input.getSelf().getPath().endsWith(this.stringEnding);
        }
    }

    public static class HasIdPredicate<T extends IdentifiableEntity<K>, K>
    implements Predicate<T> {
        private final K id;

        public static <X extends IdentifiableEntity<Y>, Y> HasIdPredicate<X, Y> forId(Y id) {
            return new HasIdPredicate(id);
        }

        private HasIdPredicate(K id) {
            this.id = id;
        }

        public boolean apply(T input) {
            return this.id.equals(input.getId());
        }
    }

    public static class HasNamePredicate<T extends NamedEntity>
    implements Predicate<T> {
        private final String name;

        public static <K extends NamedEntity> HasNamePredicate<K> forName(String name) {
            return new HasNamePredicate(name);
        }

        private HasNamePredicate(String name) {
            this.name = name;
        }

        public boolean apply(T input) {
            return this.name.equals(input.getName());
        }
    }

    public static class HasFileNamePredicate<T extends Attachment>
    implements Predicate<T> {
        private final String fileName;

        public static <K extends Attachment> HasFileNamePredicate<K> forFileName(String fileName) {
            return new HasFileNamePredicate(fileName);
        }

        private HasFileNamePredicate(String fileName) {
            this.fileName = fileName;
        }

        public boolean apply(T attachment) {
            return this.fileName.equals(((Attachment)attachment).getFilename());
        }
    }
}

