/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.exception.artificialintelligence.server.MalformedJsonPathException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAiServerService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.AiServerPatcher;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;

@Service
@Transactional
public class RestAiServerServiceImpl
implements RestAiServerService {
    @Inject
    private AiServerDao aiServerDao;
    @Inject
    private AiServerManagerService aiServerManagerService;
    @Inject
    private DSLContext dsl;
    @Inject
    private JsonPathExtractor jsonPathExtractor;
    @Inject
    private AiServerPatcher aiServerPatcher;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer findAiServerById(Long aiServerId) {
        return (AiServer)this.aiServerDao.findById((Object)aiServerId).orElseThrow(() -> ExceptionUtils.entityNotFoundException(AiServer.class, (Long)aiServerId));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public Page<AiServer> getAllAiServers(Pageable pageable) {
        return this.aiServerDao.findAll(pageable);
    }

    @Override
    @IsUltimateLicenseAvailable
    public void deleteAiServers(List<Long> aiServerIds) {
        this.aiServerManagerService.deleteAiServers(this.findExistingAiServerIds(aiServerIds));
    }

    private List<Long> findExistingAiServerIds(List<Long> aiServerIds) {
        return this.dsl.select((SelectField)Tables.AI_SERVER.SERVER_ID).from((TableLike)Tables.AI_SERVER).where(Tables.AI_SERVER.SERVER_ID.in(aiServerIds)).fetchInto(Long.class);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer createNewAiServer(AiServer server) {
        if (server.getJsonPath() != null && !this.jsonPathExtractor.isPathValid(server.getJsonPath()) && !server.getJsonPath().isEmpty()) {
            throw new MalformedJsonPathException();
        }
        this.aiServerManagerService.persist(server);
        Optional newAiServer = this.aiServerDao.findById((Object)server.getId());
        if (newAiServer.isPresent()) {
            return (AiServer)newAiServer.get();
        }
        throw new IllegalArgumentException("Failed to create a new AI server. The provided server object may be invalid or incomplete.");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer updateAiServer(Long aiServerId, AiServerDto aiServerDto) {
        AiServer aiServer = this.findAiServerById(aiServerId);
        this.aiServerPatcher.patch(aiServer, aiServerDto);
        return aiServer;
    }
}

