/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.BatchProcessingUnit;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import xsquash4gitlab.com.apollographql.apollo.api.Error;

public abstract class AbstractIssueNoteBatchUpdater
implements BatchProcessingUnit {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIssueNoteBatchUpdater.class);

    abstract Map<String, List<String>> processBatch(GitLabClient var1, List<NoteProcessInfo> var2);

    protected static void extractTopErrorLevelErrors(List<NoteProcessInfo> batch, List<Error> rawTopLevelErrors, Map<String, List<String>> errorsByIssueId) {
        if (rawTopLevelErrors == null) {
            return;
        }
        for (Error topLevelError : rawTopLevelErrors) {
            Object mutationAlias = topLevelError.getCustomAttributes().get("path");
            Integer mutationIndex = AbstractIssueNoteBatchUpdater.getMutationIndex(mutationAlias);
            if (mutationIndex != null && mutationIndex >= 0 && mutationIndex < batch.size()) {
                errorsByIssueId.computeIfAbsent(batch.get((int)mutationIndex.intValue()).issueGlobalId, k -> new ArrayList()).add(topLevelError.getMessage());
                continue;
            }
            LOGGER.error("Unhandled top-level GraphQL error.\nBatch issue IDs: {}:\nError message: {}", new Object[]{AbstractIssueNoteBatchUpdater.extractIssueIdsFromBatch(batch), topLevelError.getMessage()});
        }
    }

    private static Integer getMutationIndex(Object path) {
        String[] pathTokens;
        String mutationAliasString;
        List pathList;
        Object mutationAlias;
        if (path instanceof List && (mutationAlias = (pathList = (List)path).getFirst()) instanceof String && (mutationAliasString = (String)mutationAlias).startsWith("m_") && (pathTokens = mutationAliasString.split("_")).length == 2) {
            return Integer.parseInt(pathTokens[1]);
        }
        return null;
    }

    private static String extractIssueIdsFromBatch(List<NoteProcessInfo> batch) {
        return batch.stream().map(info -> info.issueGlobalId).collect(Collectors.joining(","));
    }
}

