/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import plugin.rtc.org.eclipse.lyo.client.oslc.resources.QmResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Link;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Occurs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcResourceShape(title="Quality Management Resource Shape", describes={"http://open-services.net/ns/qm#TestResult"})
@OslcNamespace(value="http://open-services.net/ns/qm#")
public final class TestResult
extends QmResource {
    private final Set<Link> affectedByChangeRequests = new HashSet<Link>();
    private Link executesTestScript;
    private Link reportsOnTestCase;
    private Link reportsOnTestPlan;
    private Link producedByTestExecutionRecord;
    private String status;

    @Override
    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/qm#TestResult");
    }

    public void addAffectedByChangeRequest(Link affectingChangeRequest) {
        this.affectedByChangeRequests.add(affectingChangeRequest);
    }

    @OslcDescription(value="Change request that affects the Test Result.")
    @OslcName(value="affectedByChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#affectedByChangeRequest")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Affected By Change Request")
    public Link[] getAffectedByChangeRequests() {
        return this.affectedByChangeRequests.toArray(new Link[this.affectedByChangeRequests.size()]);
    }

    @OslcDescription(value="Test Plan that the Test Result reports on.")
    @OslcName(value="reportsOnTestPlan")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#reportsOnTestPlan")
    @OslcRange(value={"http://open-services.net/ns/qm#TestPlan"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Reports On Test Plan")
    public Link getReportsOnTestPlan() {
        return this.reportsOnTestPlan;
    }

    @OslcDescription(value="Test Case that the Test Result reports on.")
    @OslcName(value="reportsOnTestCase")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#reportsOnTestCase")
    @OslcRange(value={"http://open-services.net/ns/qm#TestCase"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Reports On Test Case")
    public Link getReportsOnTestCase() {
        return this.reportsOnTestCase;
    }

    @OslcDescription(value="Test Script executed to produce the Test Result.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#executesTestScript")
    @OslcTitle(value="Executes Test Script")
    public Link getExecutesTestScript() {
        return this.executesTestScript;
    }

    @OslcDescription(value="Test Execution Record that the Test Result was produced by.")
    @OslcName(value="producedByTestExecutionRecord")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#producedByTestExecutionRecord")
    @OslcRange(value={"http://open-services.net/ns/qm#TestExecutionRecord"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Produced By Test Execution Record")
    public Link getProducedByTestExecutionRecord() {
        return this.producedByTestExecutionRecord;
    }

    @OslcDescription(value="Used to indicate the state of the Test Result based on values defined by the service provider.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#status")
    @OslcTitle(value="Status")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getStatus() {
        return this.status;
    }

    public void setAffectedByChangeRequests(Link[] affectedByChangeRequests) {
        this.affectedByChangeRequests.clear();
        if (affectedByChangeRequests != null) {
            this.affectedByChangeRequests.addAll(Arrays.asList(affectedByChangeRequests));
        }
    }

    public void setReportsOnTestPlan(Link reportsOnTestPlan) {
        this.reportsOnTestPlan = reportsOnTestPlan;
    }

    public void setReportsOnTestCase(Link reportsOnTestCase) {
        this.reportsOnTestCase = reportsOnTestCase;
    }

    public void setProducedByTestExecutionRecord(Link producedByTestExecutionRecord) {
        this.producedByTestExecutionRecord = producedByTestExecutionRecord;
    }

    public void setExecutesTestScript(Link executesTestScript) {
        this.executesTestScript = executesTestScript;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

