/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.client.oslc.resources;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import plugin.rtc.net.oauth.OAuthException;
import plugin.rtc.org.apache.wink.client.ClientResponse;
import plugin.rtc.org.eclipse.lyo.client.exception.ResourceNotFoundException;
import plugin.rtc.org.eclipse.lyo.client.oslc.OslcClient;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.CreationFactory;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Service;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ServiceProvider;

public final class RmUtil {
    public static ResourceShape lookupRequirementsInstanceShapes(String serviceProviderUrl, String oslcDomain, String oslcResourceType, OslcClient client, String requiredInstanceShape) throws IOException, OAuthException, URISyntaxException, ResourceNotFoundException {
        ClientResponse response = client.getResource(serviceProviderUrl, "application/rdf+xml");
        ServiceProvider serviceProvider = response.getEntity(ServiceProvider.class);
        if (serviceProvider != null) {
            for (Service service : serviceProvider.getServices()) {
                CreationFactory[] creationFactories;
                URI domain = service.getDomain();
                if (domain == null || !domain.toString().equals(oslcDomain) || (creationFactories = service.getCreationFactories()) == null || creationFactories.length <= 0) continue;
                for (CreationFactory creationFactory : creationFactories) {
                    for (URI resourceType : creationFactory.getResourceTypes()) {
                        URI[] instanceShapes;
                        if (resourceType.toString() == null || !resourceType.toString().equals(oslcResourceType) || (instanceShapes = creationFactory.getResourceShapes()) == null) continue;
                        for (URI typeURI : instanceShapes) {
                            response = client.getResource(typeURI.toString(), "application/rdf+xml");
                            ResourceShape resourceShape = response.getEntity(ResourceShape.class);
                            String typeTitle = resourceShape.getTitle();
                            if (typeTitle == null || !typeTitle.equalsIgnoreCase(requiredInstanceShape)) continue;
                            return resourceShape;
                        }
                    }
                }
            }
        }
        throw new ResourceNotFoundException(serviceProviderUrl, "InstanceShapes");
    }

    public static Element convertStringToHTML(String text) throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element divElement = document.createElementNS("http://www.w3.org/1999/xhtml", "div");
        divElement.setTextContent(text);
        return divElement;
    }
}

