/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.json4j;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import plugin.rtc.org.apache.wink.json4j.JSONException;
import plugin.rtc.org.apache.wink.json4j.JSONObject;
import plugin.rtc.org.apache.wink.json4j.internal.Parser;

public class OrderedJSONObject
extends JSONObject {
    private static final long serialVersionUID = -3269263069889337299L;
    private ArrayList order = new ArrayList();

    public OrderedJSONObject() {
    }

    public OrderedJSONObject(String str) throws JSONException {
        StringReader reader = new StringReader(str);
        new Parser(reader).parse(true, this);
    }

    public OrderedJSONObject(String str, boolean strict) throws JSONException {
        StringReader reader = new StringReader(str);
        new Parser(reader, strict).parse(true, this);
    }

    public OrderedJSONObject(Reader rdr) throws JSONException {
        new Parser(rdr).parse(true, this);
    }

    public OrderedJSONObject(Reader rdr, boolean strict) throws JSONException {
        new Parser(rdr, strict).parse(true, this);
    }

    public OrderedJSONObject(InputStream is) throws JSONException {
        InputStreamReader isr = null;
        if (is != null) {
            try {
                isr = new InputStreamReader(is, "UTF-8");
            }
            catch (Exception ex) {
                isr = new InputStreamReader(is);
            }
        } else {
            throw new JSONException("Inputstream cannot be null");
        }
        new Parser(isr).parse(true, this);
    }

    public OrderedJSONObject(InputStream is, boolean strict) throws JSONException {
        InputStreamReader isr = null;
        if (is != null) {
            try {
                isr = new InputStreamReader(is, "UTF-8");
            }
            catch (Exception ex) {
                isr = new InputStreamReader(is);
            }
        } else {
            throw new JSONException("Inputstream cannot be null");
        }
        new Parser(isr, strict).parse(true, this);
    }

    public OrderedJSONObject(Map map) throws JSONException {
        Iterator itr;
        Set set = map.keySet();
        if (set != null && (itr = set.iterator()) != null) {
            while (itr.hasNext()) {
                Object key = itr.next();
                String sKey = key.toString();
                this.put(sKey, map.get(key));
            }
        }
    }

    public Object put(Object key, Object value) {
        if (null == key) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!OrderedJSONObject.isValidObject(value)) {
            if (value != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + value.getClass().getName() + "] with value: [" + value.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        if (!this.containsKey(key)) {
            this.order.add(key);
        }
        return super.put(key, value);
    }

    public Object remove(Object key) {
        Object retVal = null;
        if (null == key) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.containsKey(key)) {
            retVal = super.remove(key);
            for (int i = 0; i < this.order.size(); ++i) {
                Object obj = this.order.get(i);
                if (!obj.equals(key)) continue;
                this.order.remove(i);
                break;
            }
        }
        return retVal;
    }

    public void clear() {
        super.clear();
        this.order.clear();
    }

    public Object clone() {
        OrderedJSONObject clone = (OrderedJSONObject)super.clone();
        Iterator order = clone.getOrder();
        ArrayList orderList = new ArrayList();
        while (order.hasNext()) {
            orderList.add(order.next());
            clone.order = orderList;
        }
        return clone;
    }

    public Iterator getOrder() {
        return this.order.iterator();
    }
}

