/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.json4j;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import plugin.rtc.org.apache.wink.json4j.JSONArray;
import plugin.rtc.org.apache.wink.json4j.JSONArtifact;
import plugin.rtc.org.apache.wink.json4j.JSONException;
import plugin.rtc.org.apache.wink.json4j.JSONObject;
import plugin.rtc.org.apache.wink.json4j.OrderedJSONObject;

public class JSON {
    public static final Object NULL = null;

    public static JSONArtifact parse(Reader reader, boolean order) throws JSONException, NullPointerException {
        return JSON.parse(reader, order, false);
    }

    public static JSONArtifact parse(Reader reader, boolean order, boolean strict) throws JSONException, NullPointerException {
        try {
            if (reader != null) {
                PushbackReader pReader = null;
                boolean bufferIt = false;
                Class<?> readerClass = reader.getClass();
                if (!(StringReader.class.isAssignableFrom(readerClass) || CharArrayReader.class.isAssignableFrom(readerClass) || PushbackReader.class.isAssignableFrom(readerClass) || BufferedReader.class.isAssignableFrom(readerClass))) {
                    bufferIt = true;
                }
                pReader = PushbackReader.class.isAssignableFrom(readerClass) ? (PushbackReader)reader : new PushbackReader(reader);
                Reader rdr = pReader;
                int ch = pReader.read();
                block7: while (ch != -1) {
                    switch (ch) {
                        case 123: {
                            pReader.unread(ch);
                            if (bufferIt) {
                                rdr = new BufferedReader(pReader);
                            }
                            if (order) {
                                return new OrderedJSONObject(rdr, strict);
                            }
                            return new JSONObject(rdr, strict);
                        }
                        case 91: {
                            pReader.unread(ch);
                            if (bufferIt) {
                                rdr = new BufferedReader(pReader);
                            }
                            return new JSONArray(rdr, strict);
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 32: {
                            ch = pReader.read();
                            continue block7;
                        }
                    }
                    throw new JSONException("Unexpected character: [" + (char)ch + "] while scanning JSON String for JSON type.  Invalid JSON.");
                }
                throw new JSONException("Encountered end of stream before JSON data was read.  Invalid JSON");
            }
            throw new NullPointerException("reader cannot be null.");
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
    }

    public static JSONArtifact parse(Reader reader) throws JSONException, NullPointerException {
        return JSON.parse(reader, false, false);
    }

    public static JSONArtifact parse(InputStream is, boolean order) throws JSONException, NullPointerException {
        return JSON.parse(is, order, false);
    }

    public static JSONArtifact parse(InputStream is, boolean order, boolean strict) throws JSONException, NullPointerException {
        if (is != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            }
            catch (Exception ex) {
                JSONException iox = new JSONException("Could not construct UTF-8 character reader for the InputStream");
                iox.initCause(ex);
                throw iox;
            }
            return JSON.parse(reader, order);
        }
        throw new NullPointerException("is cannot be null");
    }

    public static JSONArtifact parse(InputStream is) throws JSONException, NullPointerException {
        return JSON.parse(is, false, false);
    }

    public static JSONArtifact parse(String str, boolean order) throws JSONException, NullPointerException {
        return JSON.parse(str, order, false);
    }

    public static JSONArtifact parse(String str, boolean order, boolean strict) throws JSONException, NullPointerException {
        if (str != null) {
            return JSON.parse(new StringReader(str), order, strict);
        }
        throw new NullPointerException("str cannot be null");
    }

    public static JSONArtifact parse(String str) throws JSONException, NullPointerException {
        return JSON.parse(str, false, false);
    }
}

