/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final String lineSeparator = System.getProperty("line.separator");

    private StringUtils() {
    }

    public static String valueOf(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(lineSeparator);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.append(String.valueOf(entry.getKey()));
            builder.append("=");
            builder.append(String.valueOf(entry.getValue()));
            builder.append(lineSeparator);
        }
        builder.append("}");
        return builder.toString();
    }

    public static String valueOf(List<?> list) {
        if (list == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(lineSeparator);
        for (Object object : list) {
            builder.append(String.valueOf(object));
            builder.append(lineSeparator);
        }
        builder.append("]");
        return builder.toString();
    }

    public static String[] fastSplit(String string, String delimiter) {
        return StringUtils.fastSplit(string, delimiter, true);
    }

    public static String[] fastSplit(String string, String delimiter, boolean strict) {
        return StringUtils.fastSplit(string, delimiter, strict, false);
    }

    public static String[] fastSplitTemplate(String string, String delimiter) {
        return StringUtils.fastSplitTemplate(string, delimiter, true);
    }

    public static String[] fastSplitTemplate(String string, String delimiter, boolean strict) {
        return StringUtils.fastSplit(string, delimiter, strict, true);
    }

    public static String[] fastSplit(String string, String delimiter, boolean strict, boolean template) {
        if (string == null) {
            return new String[0];
        }
        if (string.equals("")) {
            return new String[]{""};
        }
        ArrayList<String> tmpResults = new ArrayList<String>();
        int delimiterLength = delimiter.length();
        int delimiterIndex = 0;
        int fromIndex = 0;
        int stringLen = string.length();
        int index = 0;
        while (index != -1) {
            if (fromIndex >= string.length()) {
                if (!strict) break;
                tmpResults.add("");
                break;
            }
            if (template) {
                boolean done = false;
                int brackets = 0;
                index = fromIndex;
                int maxIndex = string.length();
                while (!done) {
                    if (index >= maxIndex) {
                        index = -1;
                        done = true;
                        continue;
                    }
                    if (string.startsWith(delimiter, index) && brackets == 0) {
                        done = true;
                        continue;
                    }
                    if (string.charAt(index) == '{') {
                        ++brackets;
                    } else if (string.charAt(index) == '}') {
                        brackets = brackets == 0 ? 0 : brackets - 1;
                    }
                    ++index;
                }
            } else {
                index = string.indexOf(delimiter, fromIndex);
            }
            delimiterIndex = index == -1 ? stringLen : index;
            tmpResults.add(string.substring(fromIndex, delimiterIndex));
            fromIndex = delimiterIndex + delimiterLength;
        }
        return tmpResults.toArray(new String[tmpResults.size()]);
    }

    public static boolean isEmptyArray(Object object) {
        if (object != null) {
            if (object instanceof Object[] && ((Object[])object).length == 0) {
                return true;
            }
            if (object instanceof Collection && ((Collection)object).size() == 0) {
                return true;
            }
        }
        return false;
    }
}

