/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class HttpDateParser {
    private static final String RFC_1123_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String RFC_1036_DATE_FORMAT = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final String ANSIC_DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static final TimeZone tz = TimeZone.getTimeZone("GMT");

    private HttpDateParser() {
    }

    public static Date parseHttpDate(String date) {
        int index = date.indexOf(59);
        if (index != -1) {
            date = date.substring(0, index).trim();
        }
        int indexOfComma = date.indexOf(44);
        try {
            if (indexOfComma == -1) {
                return HttpDateParser.createSimpleDateFormat(ANSIC_DATE_FORMAT).parse(date);
            }
            if (indexOfComma == 3) {
                return HttpDateParser.createSimpleDateFormat(RFC_1123_DATE_FORMAT).parse(date);
            }
            return HttpDateParser.createSimpleDateFormat(RFC_1036_DATE_FORMAT).parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static SimpleDateFormat createSimpleDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.US);
        simpleDateFormat.setTimeZone(tz);
        return simpleDateFormat;
    }

    public static String toHttpDate(Date date) {
        return HttpDateParser.createSimpleDateFormat(RFC_1123_DATE_FORMAT).format(date);
    }
}

