/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private List<MediaType> mediaTypes = new ArrayList<MediaType>();
    private List<Locale> languages = new ArrayList<Locale>();
    private List<String> encodings = new ArrayList<String>();
    private List<Variant> variants = null;

    private void reset() {
        this.encodings.clear();
        this.languages.clear();
        this.mediaTypes.clear();
    }

    @Override
    public Variant.VariantListBuilder add() {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        this.verifyNonEmpty();
        for (MediaType mediaType : this.mediaTypes) {
            for (Locale language : this.languages) {
                for (String encoding : this.encodings) {
                    this.variants.add(new Variant(mediaType, language, encoding));
                }
            }
        }
        this.reset();
        return this;
    }

    private void verifyNonEmpty() {
        if (this.mediaTypes.size() == 0) {
            this.mediaTypes.add(null);
        }
        if (this.languages.size() == 0) {
            this.languages.add(null);
        }
        if (this.encodings.size() == 0) {
            this.encodings.add(null);
        }
    }

    @Override
    public List<Variant> build() {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        List<Variant> list = this.variants;
        this.variants = null;
        return list;
    }

    @Override
    public Variant.VariantListBuilder encodings(String ... encodings) {
        this.encodings.clear();
        for (String encoding : encodings) {
            this.encodings.add(encoding);
        }
        return this;
    }

    @Override
    public Variant.VariantListBuilder languages(Locale ... languages) {
        this.languages.clear();
        for (Locale language : languages) {
            this.languages.add(language);
        }
        return this;
    }

    @Override
    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        this.mediaTypes.clear();
        for (MediaType mediaType : mediaTypes) {
            this.mediaTypes.add(mediaType);
        }
        return this;
    }
}

