/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultivaluedMapImpl<K, V>
implements MultivaluedMap<K, V>,
Cloneable {
    private static final long serialVersionUID = -1942980976209902832L;
    private final Map<K, List<V>> map;

    public MultivaluedMapImpl() {
        this.map = new LinkedHashMap<K, List<V>>();
    }

    MultivaluedMapImpl(Comparator<K> keyComparator) {
        this.map = new TreeMap<K, List<V>>(keyComparator);
    }

    public MultivaluedMapImpl(Map<K, V> map) {
        this();
        for (K key : map.keySet()) {
            this.add(key, map.get(key));
        }
    }

    @Override
    public void add(K key, V value) {
        List<V> list = this.getOrCreate(key);
        list.add(value);
    }

    @Override
    public V getFirst(K key) {
        Object list = this.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (V)list.get(0);
    }

    @Override
    public void putSingle(K key, V value) {
        List<V> list = this.getOrCreate(key);
        list.clear();
        list.add(value);
    }

    private List<V> getOrCreate(K key) {
        List<V> list = this.get(key);
        if (list == null) {
            list = this.createValueList(key);
            this.put(key, list);
        }
        return list;
    }

    private List<V> createValueList(K key) {
        return new ArrayList();
    }

    public MultivaluedMapImpl<K, V> clone() {
        return MultivaluedMapImpl.clone(this);
    }

    public static <K, V> MultivaluedMapImpl<K, V> clone(MultivaluedMap<K, V> src) {
        MultivaluedMapImpl<K, V> clone = new MultivaluedMapImpl<K, V>();
        MultivaluedMapImpl.copy(src, clone);
        return clone;
    }

    public static <K, V> void copy(MultivaluedMap<K, V> src, MultivaluedMap<K, V> dest) {
        for (Object key : src.keySet()) {
            List value = (List)src.get(key);
            ArrayList newValue = new ArrayList();
            newValue.addAll(value);
            dest.put(key, newValue);
        }
    }

    public static <K, V> void addAll(MultivaluedMap<K, V> src, MultivaluedMap<K, V> dest) {
        for (Object key : src.keySet()) {
            List srcList = (List)src.get(key);
            ArrayList destList = (ArrayList)dest.get(key);
            if (destList == null) {
                destList = new ArrayList(srcList.size());
                dest.put(key, destList);
            }
            destList.addAll(srcList);
        }
    }

    public String toString() {
        return "[" + MultivaluedMapImpl.toString(this, ",") + "]";
    }

    public static String toString(MultivaluedMap<?, ?> map, String delimiter) {
        StringBuilder result = new StringBuilder();
        MultivaluedMap<?, ?> params = map;
        String delim = "";
        for (Object name : params.keySet()) {
            for (Object value : (List)params.get(name)) {
                result.append(delim);
                if (name == null) {
                    result.append("null");
                } else {
                    result.append(name.toString());
                }
                if (value != null) {
                    result.append('=');
                    result.append(value.toString());
                }
                delim = delimiter;
            }
        }
        return result.toString();
    }

    public static MultivaluedMap<String, String> toMultivaluedMapString(Map<String, ? extends Object> values) {
        MultivaluedMapImpl<String, String> mValues = new MultivaluedMapImpl<String, String>();
        for (String key : values.keySet()) {
            Object value = values.get(key);
            if (value == null) {
                mValues.add(key, null);
                continue;
            }
            if (value instanceof Object[]) {
                for (Object obj : (Object[])value) {
                    if (obj == null) {
                        mValues.add(key, null);
                        continue;
                    }
                    mValues.add(key, obj.toString());
                }
                continue;
            }
            if (value instanceof List) {
                for (Object obj : (List)value) {
                    if (obj == null) {
                        mValues.add(key, null);
                        continue;
                    }
                    mValues.add(key, obj.toString());
                }
                continue;
            }
            mValues.add(key, value.toString());
        }
        return mValues;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    @Override
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> t) {
        this.map.putAll(t);
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }
}

