/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.client;

import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.core.Application;
import plugin.rtc.org.apache.wink.client.ClientConfigException;
import plugin.rtc.org.apache.wink.client.handlers.ClientHandler;
import plugin.rtc.org.apache.wink.client.handlers.ConnectionHandler;
import plugin.rtc.org.apache.wink.client.internal.handlers.AcceptHeaderHandler;
import plugin.rtc.org.apache.wink.client.internal.handlers.HttpURLConnectionHandler;
import plugin.rtc.org.apache.wink.common.WinkApplication;
import plugin.rtc.org.apache.wink.common.internal.WinkConfiguration;
import plugin.rtc.org.apache.wink.common.internal.application.ApplicationFileLoader;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfig
implements Cloneable,
WinkConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfig.class);
    private String proxyHost = null;
    private int proxyPort = 80;
    private boolean followRedirects = true;
    private LinkedList<ClientHandler> handlers = new LinkedList();
    private LinkedList<Application> applications;
    private boolean modifiable = true;
    private boolean isAcceptHeaderAutoSet = true;
    private boolean loadWinkApplications = true;
    private boolean bypassHostnameVerification = false;
    private static final String WINK_CLIENT_CONNECTTIMEOUT = "wink.client.connectTimeout";
    private static final String WINK_CLIENT_READTIMEOUT = "wink.client.readTimeout";
    private static final String WINK_SUPPORT_DTD_EXPANSION = "wink.supportDTDEntityExpansion";
    private static int WINK_CLIENT_CONNECTTIMEOUT_DEFAULT = 60000;
    private static int WINK_CLIENT_READTIMEOUT_DEFAULT = 60000;
    private static boolean WINK_CLIENT_SUPPORT_DTD_EXPANSION_DEFAULT = false;
    private Properties properties = null;

    private void initDefaultApplication() {
        if (this.applications != null) {
            return;
        }
        this.applications = new LinkedList();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws FileNotFoundException {
                    final Set<Class<?>> classes = new ApplicationFileLoader(ClientConfig.this.loadWinkApplications).getClasses();
                    ClientConfig.this.applications(new WinkApplication(){

                        @Override
                        public Set<Class<?>> getClasses() {
                            return classes;
                        }

                        @Override
                        public double getPriority() {
                            return 0.1;
                        }
                    });
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ClientConfigException(e.getException());
        }
    }

    public final String getProxyHost() {
        return this.proxyHost;
    }

    public final ClientConfig proxyHost(String proxyHost) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        this.proxyHost = proxyHost;
        return this;
    }

    public final int getProxyPort() {
        return this.proxyPort;
    }

    public final ClientConfig proxyPort(int proxyPort) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        if (proxyPort <= 0) {
            proxyPort = 80;
        }
        this.proxyPort = proxyPort;
        return this;
    }

    public final int getConnectTimeout() {
        try {
            return Integer.valueOf(this.getProperties().getProperty(WINK_CLIENT_CONNECTTIMEOUT));
        }
        catch (NumberFormatException e) {
            logger.trace("Value in properties for key {} is invalid.  Reverting to default: {}", (Object)WINK_CLIENT_CONNECTTIMEOUT, (Object)WINK_CLIENT_CONNECTTIMEOUT_DEFAULT);
            this.getProperties().setProperty(WINK_CLIENT_CONNECTTIMEOUT, String.valueOf(WINK_CLIENT_CONNECTTIMEOUT_DEFAULT));
            return this.getReadTimeout();
        }
    }

    public final ClientConfig connectTimeout(int connectTimeout) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        this.getProperties().setProperty(WINK_CLIENT_CONNECTTIMEOUT, String.valueOf(connectTimeout));
        return this;
    }

    public final int getReadTimeout() {
        try {
            return Integer.valueOf(this.getProperties().getProperty(WINK_CLIENT_READTIMEOUT));
        }
        catch (NumberFormatException e) {
            logger.trace("Value in properties for key {} is invalid.  Reverting to default: {}", (Object)WINK_CLIENT_READTIMEOUT, (Object)WINK_CLIENT_READTIMEOUT_DEFAULT);
            this.getProperties().setProperty(WINK_CLIENT_READTIMEOUT, String.valueOf(WINK_CLIENT_READTIMEOUT_DEFAULT));
            return this.getReadTimeout();
        }
    }

    public final ClientConfig readTimeout(int readTimeout) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        this.getProperties().setProperty(WINK_CLIENT_READTIMEOUT, String.valueOf(readTimeout));
        return this;
    }

    public final boolean isSupportDTDExpansion() {
        return Boolean.valueOf(this.getProperties().getProperty(WINK_SUPPORT_DTD_EXPANSION));
    }

    public final ClientConfig supportDTDExpansion(boolean supportDTDExpansion) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        this.getProperties().setProperty(WINK_SUPPORT_DTD_EXPANSION, String.valueOf(supportDTDExpansion));
        return this;
    }

    public final boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public final ClientConfig followRedirects(boolean followRedirects) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        this.followRedirects = followRedirects;
        return this;
    }

    public final boolean isAcceptHeaderAutoSet() {
        return this.isAcceptHeaderAutoSet;
    }

    public final ClientConfig acceptHeaderAutoSet(boolean isAcceptHeaderAutoSet) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        this.isAcceptHeaderAutoSet = isAcceptHeaderAutoSet;
        return this;
    }

    public final List<ClientHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public final ClientConfig handlers(ClientHandler ... handlers) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        for (ClientHandler handler : handlers) {
            this.handlers.add(handler);
        }
        return this;
    }

    ClientConfig build() {
        if (this.isAcceptHeaderAutoSet) {
            this.handlers.add(new AcceptHeaderHandler());
        }
        this.handlers.add(this.getConnectionHandler());
        this.modifiable = false;
        return this;
    }

    protected ConnectionHandler getConnectionHandler() {
        return new HttpURLConnectionHandler();
    }

    public final List<Application> getApplications() {
        if (this.applications == null) {
            this.initDefaultApplication();
        }
        return Collections.unmodifiableList(this.applications);
    }

    public final ClientConfig applications(Application ... applications) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        if (this.applications == null) {
            this.initDefaultApplication();
        }
        for (Application application : applications) {
            this.applications.add(application);
        }
        return this;
    }

    protected ClientConfig clone() {
        if (this.applications == null) {
            this.initDefaultApplication();
        }
        try {
            ClientConfig clone = (ClientConfig)super.clone();
            clone.handlers = new LinkedList<ClientHandler>(this.handlers);
            clone.applications = new LinkedList<Application>(this.applications);
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.getProperties());
            clone.setProperties(props);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLoadWinkApplications(boolean loadWinkApplications) {
        this.loadWinkApplications = loadWinkApplications;
    }

    public boolean isLoadWinkApplications() {
        return this.loadWinkApplications;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                String connectTimeoutString = System.getProperty(WINK_CLIENT_CONNECTTIMEOUT, String.valueOf(WINK_CLIENT_CONNECTTIMEOUT_DEFAULT));
                int n = Integer.parseInt(connectTimeoutString);
                this.properties.put(WINK_CLIENT_CONNECTTIMEOUT, String.valueOf(n));
                logger.trace("Wink client connectTimeout default value is {}.", (Object)n);
            }
            catch (Exception e) {
                logger.trace("Error processing {} system property: {}", (Object)WINK_CLIENT_CONNECTTIMEOUT, (Object)e);
            }
            try {
                String readTimeoutString = System.getProperty(WINK_CLIENT_READTIMEOUT, String.valueOf(WINK_CLIENT_READTIMEOUT_DEFAULT));
                int n = Integer.parseInt(readTimeoutString);
                this.properties.put(WINK_CLIENT_READTIMEOUT, String.valueOf(n));
                logger.trace("Wink client readTimeout default value is {}.", (Object)n);
            }
            catch (Exception e) {
                logger.trace("Error processing {} system property: {}", (Object)WINK_CLIENT_READTIMEOUT, (Object)e);
            }
            try {
                String supportDTD = System.getProperty(WINK_SUPPORT_DTD_EXPANSION, String.valueOf(WINK_CLIENT_SUPPORT_DTD_EXPANSION_DEFAULT));
                boolean bl = Boolean.valueOf(supportDTD);
                this.properties.put(WINK_SUPPORT_DTD_EXPANSION, String.valueOf(bl));
                if (logger.isTraceEnabled()) {
                    logger.trace("Wink client readTimeout default value is {}.", (Object)String.valueOf(bl));
                }
            }
            catch (Exception e) {
                logger.trace("Error processing {} system property: {}", (Object)WINK_SUPPORT_DTD_EXPANSION, (Object)e);
            }
        }
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        if (!this.modifiable) {
            throw new ClientConfigException(Messages.getMessage("clientConfigurationUnmodifiable"));
        }
        if (properties == null) {
            this.properties.clear();
            return;
        }
        this.properties = properties;
    }

    public boolean getBypassHostnameVerification() {
        return this.bypassHostnameVerification;
    }

    public void setBypassHostnameVerification(boolean bypassHostnameVerification) {
        this.bypassHostnameVerification = bypassHostnameVerification;
    }
}

