/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.jena.iri.impl;

import java.io.IOException;
import java.text.Normalizer;
import plugin.rtc.org.apache.jena.iri.ViolationCodes;
import plugin.rtc.org.apache.jena.iri.impl.Parser;

abstract class AbsLexer
implements ViolationCodes {
    protected Parser parser;
    protected int range;

    AbsLexer() {
    }

    public synchronized void analyse(Parser p, int r) {
        this.parser = p;
        this.range = r;
        if (!this.parser.has(this.range)) {
            return;
        }
        this.parser.uri.getChars(this.parser.start(this.range), this.parser.end(this.range), this.zzBuffer(), 0);
        try {
            this.yylex();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void analyse(Parser p, int r, String str, int strt, int finish) {
        this.parser = p;
        this.range = r;
        str.getChars(strt, finish, this.zzBuffer(), 0);
        try {
            this.yylex();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    abstract int yylex() throws IOException;

    abstract char[] zzBuffer();

    protected void error(int e) {
        this.parser.recordError(this.range, e);
    }

    protected final void rule(int rule) {
        this.parser.matchedRule(this.range, rule, this.yytext());
    }

    abstract String yytext();

    protected void surrogatePair() {
        String txt = this.yytext();
        this.difficultCodePoint(Character.toCodePoint(txt.charAt(0), txt.charAt(1)), txt);
    }

    private void difficultCodePoint(int codePoint, String txt) {
        int lowBits;
        this.error(22);
        if (codePoint > 55295 && codePoint < 57344) {
            this.error(6);
        }
        if (codePoint > 65533 && codePoint < 65536) {
            this.error(6);
        }
        if (codePoint >= 64976 && codePoint <= 64991) {
            this.error(7);
        }
        if (codePoint > 65536 && ((lowBits = codePoint & 0xFFFF) == 65534 || lowBits == 65535)) {
            this.error(7);
        }
        if (AbsLexer.isDeprecated(codePoint)) {
            this.error(48);
        }
        if (!Character.isDefined(codePoint)) {
            this.error(49);
        }
        switch (Character.getType(codePoint)) {
            case 18: {
                this.error(50);
                break;
            }
            case 15: {
                this.error(51);
                break;
            }
            case 0: {
                this.error(52);
            }
        }
        if (!Normalizer.isNormalized(txt, Normalizer.Form.NFC)) {
            this.error(46);
        }
        if (!Normalizer.isNormalized(txt, Normalizer.Form.NFKC)) {
            this.error(47);
        }
        if (Character.isWhitespace(codePoint)) {
            this.error(55);
        }
        if (this.isCompatibilityChar(codePoint)) {
            this.error(56);
        }
    }

    private boolean isCompatibilityChar(int codePoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        if (block == Character.UnicodeBlock.CJK_COMPATIBILITY) {
            switch (codePoint) {
                case 64014: 
                case 64015: 
                case 64017: 
                case 64019: 
                case 64020: 
                case 64031: 
                case 64033: 
                case 64035: 
                case 64036: 
                case 64039: 
                case 64040: 
                case 64041: {
                    return false;
                }
            }
            return true;
        }
        if (block == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || block == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT || block == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || block == Character.UnicodeBlock.KANGXI_RADICALS || block == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO) {
            return true;
        }
        String cp = new String(new int[]{codePoint}, 0, 1);
        return !Normalizer.normalize(cp, Normalizer.Form.NFD).equals(Normalizer.normalize(cp, Normalizer.Form.NFKD));
    }

    protected void difficultChar() {
        this.difficultCodePoint(this.yytext().charAt(0), this.yytext());
    }

    private static boolean isDeprecated(int codePoint) {
        if (codePoint < 329) {
            return false;
        }
        if (codePoint >= 917536 && codePoint <= 917631) {
            return true;
        }
        switch (codePoint) {
            case 329: 
            case 1651: 
            case 3959: 
            case 3961: 
            case 6051: 
            case 6052: 
            case 8298: 
            case 8299: 
            case 8300: 
            case 8301: 
            case 8302: 
            case 8303: 
            case 9001: 
            case 9002: 
            case 917505: {
                return true;
            }
        }
        return false;
    }
}

