/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.http.client.protocol;

import java.io.IOException;
import plugin.rtc.org.apache.http.HttpEntity;
import plugin.rtc.org.apache.http.HttpEntityEnclosingRequest;
import plugin.rtc.org.apache.http.HttpException;
import plugin.rtc.org.apache.http.HttpRequest;
import plugin.rtc.org.apache.http.HttpRequestInterceptor;
import plugin.rtc.org.apache.http.HttpVersion;
import plugin.rtc.org.apache.http.ProtocolVersion;
import plugin.rtc.org.apache.http.annotation.Contract;
import plugin.rtc.org.apache.http.annotation.ThreadingBehavior;
import plugin.rtc.org.apache.http.client.config.RequestConfig;
import plugin.rtc.org.apache.http.client.protocol.HttpClientContext;
import plugin.rtc.org.apache.http.protocol.HttpContext;
import plugin.rtc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

