/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.javax.ws.rs.core;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import plugin.rtc.javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaType {
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE = new MediaType("application", "atom+xml");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE = new MediaType("application", "x-www-form-urlencoded");
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE = new MediaType("application", "json");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE = new MediaType("application", "octet-stream");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MediaType APPLICATION_SVG_XML_TYPE = new MediaType("application", "svg+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_XML_TYPE = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE = new MediaType("application", "xml");
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart", "form-data");
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE = new MediaType("text", "html");
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE = new MediaType("text", "plain");
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE = new MediaType("text", "xml");
    public static final String WILDCARD = "*/*";
    public static final MediaType WILDCARD_TYPE = new MediaType("*", "*");
    private final String type;
    private final String subtype;
    private final Map<String, String> params;
    private static final RuntimeDelegate.HeaderDelegate<MediaType> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(MediaType.class);

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type == null ? MEDIA_TYPE_WILDCARD : type;
        this.subtype = subtype == null ? MEDIA_TYPE_WILDCARD : subtype;
        if (parameters == null) {
            this.params = Collections.emptyMap();
        } else {
            TreeMap<String, String> temp = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (String key : parameters.keySet()) {
                temp.put(key.toLowerCase(), parameters.get(key));
            }
            this.params = Collections.unmodifiableMap(temp);
        }
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, null);
    }

    public MediaType() {
        this(MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD);
    }

    public static MediaType valueOf(String type) throws IllegalArgumentException {
        return delegate.fromString(type);
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return MEDIA_TYPE_WILDCARD.equals(this.getType());
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return MEDIA_TYPE_WILDCARD.equals(this.getSubtype());
    }

    public Map<String, String> getParameters() {
        return this.params;
    }

    public boolean isCompatible(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return true;
        }
        if (this.isWildcardSubtype() || other.isWildcardSubtype()) {
            return this.getType().equalsIgnoreCase(other.getType());
        }
        return this.getType().equalsIgnoreCase(other.getType()) && this.getSubtype().equalsIgnoreCase(other.getSubtype());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.getType().equalsIgnoreCase(other.getType()) && this.getSubtype().equalsIgnoreCase(other.getSubtype()) && ((Object)this.getParameters()).equals(other.getParameters());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getType().toLowerCase().hashCode();
        result = 31 * result + this.getSubtype().toLowerCase().hashCode();
        result = 31 * result + ((Object)this.getParameters()).hashCode();
        return result;
    }

    public String toString() {
        return delegate.toString(this);
    }
}

