/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.javax.ws.rs.core;

import plugin.rtc.javax.ws.rs.ext.RuntimeDelegate;

public class Cookie {
    public static final int DEFAULT_VERSION = 1;
    private final String name;
    private final String value;
    private final String path;
    private final String domain;
    private final int version;
    private static final RuntimeDelegate.HeaderDelegate<Cookie> headerDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(Cookie.class);

    public Cookie(String name, String value) {
        this(name, value, null, null);
    }

    public Cookie(String name, String value, String path, String domain) {
        this(name, value, path, domain, 1);
    }

    public Cookie(String name, String value, String path, String domain, int version2) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.version = version2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cookie other = (Cookie)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.domain == null ? other.domain != null : !this.domain.equals(other.domain));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return headerDelegate.toString(this);
    }

    public static Cookie valueOf(String value) {
        return headerDelegate.fromString(value);
    }
}

