/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;

public class BindingVectorMultiSet {
    protected Map<BindingVector, Map<BindingVector, Count>> data = new HashMap<BindingVector, Map<BindingVector, Count>>();
    protected byte[] matchIndices;

    public BindingVectorMultiSet(byte[] matchIndices) {
        this.matchIndices = matchIndices;
    }

    public void add(BindingVector env) {
        Count c = this.get(env);
        if (c == null) {
            this.put(env, new Count(1));
        } else {
            c.inc();
        }
    }

    protected Count get(BindingVector env) {
        Map<BindingVector, Count> set = this.getRawSubSet(env);
        return set == null ? null : set.get(env);
    }

    protected BindingVector getPartialEnv(BindingVector env) {
        Node[] envNodes = env.getEnvironment();
        Node[] partialEnv = new Node[envNodes.length];
        for (byte i : this.matchIndices) {
            partialEnv[i] = envNodes[i];
        }
        return new BindingVector(partialEnv);
    }

    protected Map<BindingVector, Count> getRawSubSet(BindingVector env) {
        return this.data.get(this.getPartialEnv(env));
    }

    public Iterator<BindingVector> getSubSet(BindingVector env) {
        HashMap rawSubSet = this.getRawSubSet(env);
        return (rawSubSet == null ? new HashMap(0) : rawSubSet).keySet().iterator();
    }

    protected void put(BindingVector env, Count c) {
        Map<BindingVector, Count> set = this.getRawSubSet(env);
        if (set == null) {
            set = new HashMap<BindingVector, Count>();
            this.data.put(this.getPartialEnv(env), set);
        }
        set.put(env, c);
    }

    public void putAll(BindingVectorMultiSet queue) {
        for (BindingVector env : queue.data.keySet()) {
            Map<BindingVector, Count> set = this.getRawSubSet(env);
            if (set == null) {
                set = new HashMap<BindingVector, Count>();
                this.data.put(env, set);
            }
            set.putAll(queue.data.get(env));
        }
    }

    public void remove(BindingVector env) {
        BindingVector key = this.getPartialEnv(env);
        Map<BindingVector, Count> set = this.data.get(key);
        if (set != null) {
            Count c = set.get(env);
            if (c != null) {
                if (c.getCount() > 1) {
                    c.dec();
                } else {
                    set.remove(env);
                }
            }
            if (set.isEmpty()) {
                this.data.remove(key);
            }
        }
    }

    protected static class Count {
        int count;

        public Count(int count) {
            this.count = count;
        }

        public void dec() {
            --this.count;
        }

        public int getCount() {
            return this.count;
        }

        public void inc() {
            ++this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

