/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys;

import java.util.HashMap;
import java.util.Map;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Builtin;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.AddOne;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.AssertDisjointPairs;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Bound;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.CountLiteralValues;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Difference;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Drop;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Equal;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.GE;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.GreaterThan;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Hide;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.IsBNode;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.IsDType;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.IsFunctor;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.IsLiteral;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.LE;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.LessThan;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListContains;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListEntry;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListEqual;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListLength;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListMapAsObject;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListMapAsSubject;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListNotContains;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.ListNotEqual;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.MakeInstance;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.MakeSkolem;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.MakeTemp;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Max;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Min;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.NoValue;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.NotBNode;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.NotDType;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.NotEqual;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.NotFunctor;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.NotLiteral;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Now;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Print;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Product;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Quotient;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Regex;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Remove;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.StrConcat;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Sum;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Table;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.TableAll;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.Unbound;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins.UriConcat;

public class BuiltinRegistry {
    public static BuiltinRegistry theRegistry = new BuiltinRegistry();
    protected Map<String, Builtin> builtins = new HashMap<String, Builtin>();
    protected Map<String, Builtin> builtinsByURI = new HashMap<String, Builtin>();

    public void register(String functor, Builtin impl) {
        this.builtins.put(functor, impl);
        this.builtinsByURI.put(impl.getURI(), impl);
    }

    public void register(Builtin impl) {
        this.builtins.put(impl.getName(), impl);
        this.builtinsByURI.put(impl.getURI(), impl);
    }

    public Builtin getImplementation(String functor) {
        return this.builtins.get(functor);
    }

    public Builtin getImplementationByURI(String uri) {
        return this.builtinsByURI.get(uri);
    }

    static {
        theRegistry.register(new Print());
        theRegistry.register(new AddOne());
        theRegistry.register(new LessThan());
        theRegistry.register(new GreaterThan());
        theRegistry.register(new LE());
        theRegistry.register(new GE());
        theRegistry.register(new Equal());
        theRegistry.register(new NotFunctor());
        theRegistry.register(new IsFunctor());
        theRegistry.register(new NotEqual());
        theRegistry.register(new MakeTemp());
        theRegistry.register(new NoValue());
        theRegistry.register(new Remove());
        theRegistry.register(new Drop());
        theRegistry.register(new Sum());
        theRegistry.register(new Difference());
        theRegistry.register(new Product());
        theRegistry.register(new Quotient());
        theRegistry.register(new Bound());
        theRegistry.register(new Unbound());
        theRegistry.register(new IsLiteral());
        theRegistry.register(new NotLiteral());
        theRegistry.register(new IsBNode());
        theRegistry.register(new NotBNode());
        theRegistry.register(new IsDType());
        theRegistry.register(new NotDType());
        theRegistry.register(new CountLiteralValues());
        theRegistry.register(new Max());
        theRegistry.register(new Min());
        theRegistry.register(new ListLength());
        theRegistry.register(new ListEntry());
        theRegistry.register(new ListEqual());
        theRegistry.register(new ListNotEqual());
        theRegistry.register(new ListContains());
        theRegistry.register(new ListNotContains());
        theRegistry.register(new ListMapAsSubject());
        theRegistry.register(new ListMapAsObject());
        theRegistry.register(new MakeInstance());
        theRegistry.register(new Table());
        theRegistry.register(new TableAll());
        theRegistry.register(new MakeSkolem());
        theRegistry.register(new Hide());
        theRegistry.register(new StrConcat());
        theRegistry.register(new UriConcat());
        theRegistry.register(new Regex());
        theRegistry.register(new Now());
        theRegistry.register(new AssertDisjointPairs());
    }
}

