/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.n3.turtle;

import java.io.InputStream;
import java.io.Reader;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.n3.turtle.TurtleParseException;
import plugin.rtc.com.hp.hpl.jena.n3.turtle.TurtleRDFGraphInserter;
import plugin.rtc.com.hp.hpl.jena.n3.turtle.parser.ParseException;
import plugin.rtc.com.hp.hpl.jena.n3.turtle.parser.TokenMgrError;
import plugin.rtc.com.hp.hpl.jena.n3.turtle.parser.TurtleParser;
import plugin.rtc.com.hp.hpl.jena.util.FileUtils;

public class ParserTurtle {
    public void parse(Graph graph, String baseURI, InputStream in) {
        Reader reader = FileUtils.asUTF8(in);
        this.parse(graph, baseURI, reader);
    }

    public void parse(Graph graph, String baseURI, Reader reader) {
        try {
            TurtleParser parser = new TurtleParser(reader);
            parser.setEventHandler(new TurtleRDFGraphInserter(graph));
            parser.setBaseURI(baseURI);
            parser.parse();
        }
        catch (ParseException | TokenMgrError ex) {
            throw new TurtleParseException(ex.getMessage());
        }
        catch (TurtleParseException ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new TurtleParseException(th.getMessage(), th);
        }
    }
}

