/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler.assemblers;

import java.util.ArrayList;
import java.util.List;
import plugin.rtc.com.hp.hpl.jena.assembler.Assembler;
import plugin.rtc.com.hp.hpl.jena.assembler.JA;
import plugin.rtc.com.hp.hpl.jena.assembler.Mode;
import plugin.rtc.com.hp.hpl.jena.assembler.RuleSet;
import plugin.rtc.com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.StmtIterator;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Rule;

public class RuleSetAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.RuleSet);
        return RuleSetAssembler.createRuleSet(a, root);
    }

    public static RuleSet createRuleSet(Assembler a, Resource root) {
        return RuleSet.create(RuleSetAssembler.addRules(new ArrayList<Rule>(), a, root));
    }

    public static List<Rule> addRules(List<Rule> result, Assembler a, Resource root) {
        RuleSetAssembler.addLiteralRules(root, result);
        RuleSetAssembler.addIndirectRules(a, root, result);
        RuleSetAssembler.addExternalRules(root, result);
        return result;
    }

    private static void addIndirectRules(Assembler a, Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rules);
        while (it.hasNext()) {
            Resource r = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(((RuleSet)a.open(r)).getRules());
        }
    }

    private static void addExternalRules(Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rulesFrom);
        while (it.hasNext()) {
            Resource s = RuleSetAssembler.getResource(it.nextStatement());
            result.addAll(Rule.rulesFromURL(s.getURI()));
        }
    }

    private static void addLiteralRules(Resource root, List<Rule> result) {
        StmtIterator it = root.listProperties(JA.rule);
        while (it.hasNext()) {
            String s = RuleSetAssembler.getString(it.nextStatement());
            result.addAll(Rule.parseRules(s));
        }
    }
}

