/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler.assemblers;

import plugin.rtc.com.hp.hpl.jena.assembler.Assembler;
import plugin.rtc.com.hp.hpl.jena.assembler.JA;
import plugin.rtc.com.hp.hpl.jena.assembler.Mode;
import plugin.rtc.com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Literal;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Property;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Resource;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;
import plugin.rtc.com.hp.hpl.jena.rdf.model.StmtIterator;
import plugin.rtc.com.hp.hpl.jena.shared.PrefixMapping;

public class PrefixMappingAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.PrefixMapping);
        return PrefixMappingAssembler.getPrefixes(a, root, PrefixMapping.Factory.create());
    }

    public static PrefixMapping getPrefixes(Assembler a, Resource root, PrefixMapping result) {
        PrefixMappingAssembler.setSimplePrefixes(root, result);
        PrefixMappingAssembler.includePrefixesFor(a, root, result, JA.includes);
        PrefixMappingAssembler.includePrefixesFor(a, root, result, JA.prefixMapping);
        return result;
    }

    private static void includePrefixesFor(Assembler a, Resource root, PrefixMapping result, Property includeUsing) {
        StmtIterator it = root.listProperties(includeUsing);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            PrefixMapping sub = (PrefixMapping)a.open(PrefixMappingAssembler.getResource(s));
            result.setNsPrefixes(sub);
        }
    }

    private static void setSimplePrefixes(Resource root, PrefixMapping result) {
        if (root.hasProperty(JA.prefix)) {
            Literal prefix = PrefixMappingAssembler.getUniqueLiteral(root, JA.prefix);
            Literal namespace = PrefixMappingAssembler.getUniqueLiteral(root, JA.namespace);
            result.setNsPrefix(prefix.getLexicalForm(), namespace.getLexicalForm());
        }
    }
}

