/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.assembler;

import plugin.rtc.com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import plugin.rtc.com.hp.hpl.jena.rdf.model.RDFNode;
import plugin.rtc.com.hp.hpl.jena.rdf.model.Statement;

public class BadObjectException
extends AssemblerException {
    protected final RDFNode object;

    public BadObjectException(Statement s) {
        super(s.getSubject(), BadObjectException.makeMessage(s));
        this.object = s.getObject();
    }

    private static String makeMessage(Statement s) {
        RDFNode subject = s.getObject();
        return "the " + BadObjectException.typeOf(subject) + " " + BadObjectException.nice(subject) + " is unsuitable as the object of a " + BadObjectException.nice(s.getPredicate()) + " statement";
    }

    private static String typeOf(RDFNode x) {
        return x.isAnon() ? "bnode" : (x.isLiteral() ? "literal" : "resource");
    }

    public RDFNode getObject() {
        return this.object;
    }
}

