/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.rtc.RtcClient;
import org.squashtest.tm.service.spi.OslcBugTrackerConnector;

@Component
@Scope(value="prototype")
public class RtcConnector
implements OslcBugTrackerConnector {
    private BugTracker bugTracker;
    @Inject
    private RtcClient client;
    @Inject
    @Named(value="oslcBugTrackerInterfaceDescriptor")
    private BugTrackerInterfaceDescriptor descriptor;

    public void setBugTracker(BugTracker bugTracker) {
        this.bugTracker = bugTracker;
    }

    public void authenticate(Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.client.init(this.bugTracker, credentials);
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerNoCredentialsException, BugTrackerRemoteException {
        this.authenticate(credentials);
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.descriptor;
    }

    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        return this.client.createReportIssueTemplate(projectName);
    }

    public RemoteIssue findIssue(String key) {
        return this.client.findIssue(key);
    }

    public URL makeViewIssueUrl(BugTracker bugTracker, String issueId) {
        return this.client.makeViewIssueUrl(bugTracker, issueId);
    }

    public List<RemoteIssue> findIssues(Collection<String> issueKeys) {
        return issueKeys.isEmpty() ? Collections.emptyList() : this.client.findIssues(issueKeys);
    }
}

