/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.internal.service;

import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.wizard.campaignassistant.internal.exception.InvalidModelException;
import org.squashtest.tm.wizard.campaignassistant.internal.repository.WizardDao;
import org.squashtest.tm.wizard.campaignassistant.internal.service.CampaignAssistantWizardService;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationReplicationCriteria;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationReplicationModel;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationTestPlanItemDto;

@Service
@Transactional
public class CampaignAssistantWizardServiceImpl
implements CampaignAssistantWizardService {
    @Inject
    private WizardDao wizardDao;
    @Inject
    private IterationModificationService iterationService;
    @Inject
    private IterationTestPlanManagerService testPlanService;
    @Inject
    private CustomCampaignModificationService customCampaignModificationService;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private BugTrackersLocalService connector;
    @Inject
    private BugTrackerFinderService bugTrackerFinderService;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;

    @Override
    public List<NamedReference> getIterationsByCampaignId(long campaignId) {
        return this.wizardDao.getIterationsByCampaignId(campaignId);
    }

    @Override
    public PagedCollectionHolder<List<IterationTestPlanItemDto>> getReplicatedITPI(IterationReplicationCriteria criteria, PagingAndSorting pas) {
        Iteration sourceIteration = (Iteration)this.iterationService.findById(criteria.getIterationId());
        List sourceTestPlanItems = sourceIteration.getTestPlanItems();
        ArrayList<IterationTestPlanItemDto> targetTestPlan = new ArrayList<IterationTestPlanItemDto>();
        for (TestPlanItem itpi : sourceTestPlanItems) {
            if (itpi.getReferencedTestCase() == null || !criteria.itpiComplies(itpi)) continue;
            IterationTestPlanItemDto itpiDto = new IterationTestPlanItemDto(itpi, criteria.isKeepTestSuites(), criteria.isKeepAssignees());
            targetTestPlan.add(itpiDto);
        }
        return new PagingBackedPagedCollectionHolder((Paging)pas, (long)targetTestPlan.size(), targetTestPlan);
    }

    @Override
    public List<IterationTestPlanItemDto> getReplicatedITPI(IterationReplicationCriteria criteria) {
        Iteration sourceIteration = (Iteration)this.iterationService.findById(criteria.getIterationId());
        List sourceTestPlanItems = sourceIteration.getTestPlanItems();
        ArrayList<IterationTestPlanItemDto> targetTestPlan = new ArrayList<IterationTestPlanItemDto>();
        for (TestPlanItem itpi : sourceTestPlanItems) {
            if (itpi.getReferencedTestCase() == null || !criteria.itpiComplies(itpi)) continue;
            IterationTestPlanItemDto itpiDto = new IterationTestPlanItemDto(itpi, criteria.isKeepTestSuites(), criteria.isKeepAssignees());
            targetTestPlan.add(itpiDto);
        }
        return targetTestPlan;
    }

    @Override
    public Long replicateIteration(IterationReplicationModel replicationModel) {
        String targetName = replicationModel.getIterationName();
        if (targetName.isEmpty()) {
            throw new InvalidModelException();
        }
        Iteration sourceIteration = (Iteration)this.iterationService.findById(replicationModel.getSourceIterationId().longValue());
        Campaign sourceCampaign = sourceIteration.getCampaign();
        if (!sourceCampaign.isContentNameAvailable(targetName)) {
            throw new DuplicateNameException(targetName, targetName);
        }
        Iteration targetIteration = replicationModel.extractIteration((CampaignLibrary)sourceCampaign.getLibrary());
        List copiedTestPlan = this.testPlanService.findTestPlanItems(replicationModel.getItpiIds());
        this.iterationDao.persist((Object)targetIteration);
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)targetIteration, (GenericProject)sourceIteration.getProject());
        sourceCampaign.addContent(targetIteration);
        this.replicateTestPlan(targetIteration, copiedTestPlan, replicationModel.isKeepAssignees(), replicationModel.isKeepTestSuites());
        return targetIteration.getId();
    }

    private void replicateTestPlan(Iteration targetIteration, List<TestPlanItem> testPlanItems, boolean copyAssignees, boolean copyTestSuites) {
        for (TestPlanItem sourceItpi : testPlanItems) {
            if (sourceItpi.isTestCaseDeleted()) continue;
            TestPlanItem targetItpi = targetIteration.getTestPlan().createAndAddTestPlanItem(sourceItpi.getReferencedTestCase(), sourceItpi.getReferencedDataset(), null);
            if (copyAssignees) {
                targetItpi.setAssignee(sourceItpi.getAssignee());
            }
            this.copyTestSuitesIfNeeded(copyTestSuites, targetIteration, sourceItpi, targetItpi);
        }
    }

    private void copyTestSuitesIfNeeded(boolean copyTestSuites, Iteration targetIteration, TestPlanItem sourceItpi, TestPlanItem targetItpi) {
        if (copyTestSuites) {
            for (TestSuite sourceSuite : sourceItpi.getTestSuites()) {
                TestSuite targetSuite = null;
                try {
                    try {
                        targetSuite = targetIteration.getTestSuiteByName(sourceSuite.getName());
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        targetSuite = sourceSuite.createCopy();
                        this.iterationService.addTestSuite(targetIteration.getId().longValue(), targetSuite);
                        Objects.requireNonNull(targetSuite).bindTestPlanItem(targetItpi);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    ((TestSuite)Objects.requireNonNull(targetSuite)).bindTestPlanItem(targetItpi);
                    throw throwable;
                }
                Objects.requireNonNull(targetSuite).bindTestPlanItem(targetItpi);
            }
        }
    }

    @Override
    public <NODE> NODE coerceIntoNode(EntityReference ref) {
        return this.wizardDao.coerceIntoNode(ref);
    }

    @Override
    public List<RemoteIssue> findIssues(long iterationId, long serverId) {
        List<String> issueKeys = this.wizardDao.findIssues(iterationId, serverId);
        BugTracker bt = this.bugTrackerFinderService.findById(serverId);
        return this.connector.getIssues(null, issueKeys, bt);
    }

    @Override
    public List<RemoteIssue> findIssuesOnlyLastExec(long iterationId, long serverId) {
        ArrayList<String> issueKeys = new ArrayList<String>();
        BugTracker bt = this.bugTrackerFinderService.findById(serverId);
        Iteration iter = (Iteration)this.iterationService.findById(iterationId);
        List itpis = iter.getTestPlanItems();
        for (TestPlanItem itpi : itpis) {
            Execution lastExec = itpi.getLatestExecution();
            if (lastExec == null || lastExec.getIssues() == null || lastExec.getIssues().isEmpty() || lastExec.getReferencedTestCase() == null) continue;
            for (Issue issue : lastExec.getIssues()) {
                if (issue.getId() == null || issue.getRemoteIssueId() == null) continue;
                issueKeys.add(issue.getRemoteIssueId());
            }
        }
        return this.connector.getIssues(null, issueKeys, bt);
    }

    @Override
    public List<Long> findItpisByRemoteIssues(long iterationId, List<String> remoteIds) {
        return this.wizardDao.findItpisByRemoteIssues(iterationId, remoteIds);
    }

    @Override
    public AuthenticationStatus checkBugtrackerStatus(long projectId) {
        return this.connector.checkAuthenticationStatus(Long.valueOf(projectId));
    }

    @Override
    public Integer getNbIterations(long iterationId) {
        long campaignId = ((Iteration)this.iterationService.findById(iterationId)).getCampaign().getId();
        return this.customCampaignModificationService.countIterations(Long.valueOf(campaignId));
    }

    @Override
    public boolean isWizardEnabledOnProject(long projectId) {
        return this.wizardDao.isWizardEnabledOnProject(projectId);
    }
}

