/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.requirements.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.AttachReq;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.CufData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.FolderData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.ProjectData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.ReqLinkData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.RequirementVersionData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.TestCaseData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.query.RequirementTreeQueryFinder;
import org.squashtest.tm.plugin.report.legacybooks.requirements.query.RequirementTreeQueryFormatter;

public class RequirementsTreeQuery
implements ReportQuery,
InitializingBean {
    private static final String MILESTONES = "milestones";
    private static final String REQUIREMENTS_IDS = "requirementsIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String REQUIREMENTS_SELECTION_MODE = "requirementsSelectionMode";
    private static final String REQUIREMENT_FOLDERS = "requirement-folders";
    private static final String REQUIREMENTS = "requirements";
    private static final String HIGH_LEVEL_REQUIREMENTS = "high-level-requirements";
    private static final Object TAGS = "tags";
    private RequirementTreeQueryFinder queryFinder = new RequirementTreeQueryFinder();
    private RequirementTreeQueryFormatter formatter = new RequirementTreeQueryFormatter();
    protected SqlQueryRunner runner;
    private CurrentUserHelper currentUserHelper;

    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void setCurrentUserHelper(CurrentUserHelper currentUserHelper) {
        this.currentUserHelper = currentUserHelper;
    }

    public void afterPropertiesSet() throws Exception {
        this.queryFinder.setRunner(this.runner);
        this.formatter.setQueryFinder(this.queryFinder);
    }

    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        Collection<Long> versionIds = this.getReqVersionIdList(crit);
        Collection<Long> nodeIds = this.queryFinder.findIdsByVersions(versionIds);
        Collection<Object[]> rawFolderData = this.queryFinder.getFoldersDataForVersionIds(versionIds);
        Collection<Object[]> rawProjectData = this.queryFinder.getProjectDataForVersionIds(versionIds);
        Collection<Object[]> rawReqVersionData = this.queryFinder.getReqVersionsDataForVersionIds(versionIds);
        Collection<Object[]> rawBoundTCData = this.queryFinder.getTestCasesDataForVersionIds(versionIds);
        Collection<Object[]> rawCufData = this.queryFinder.getCufsDataForVersionIds(versionIds);
        Collection<Object[]> rawRtfCufData = this.queryFinder.getRtfCufsDataForVersionIds(versionIds);
        Collection<Object[]> numRtfCufData = this.queryFinder.getNumCufsDataForVersionIds(versionIds);
        Collection<Object[]> rawtagCufData = this.queryFinder.getTagCufsDataForVersionIds(versionIds);
        Collection<Object[]> rawreqLinkData = this.queryFinder.getreqLinkDataQueryForReqIds(versionIds);
        Collection<Object[]> rawAttachReq = this.queryFinder.getAttachReqForReqIds(nodeIds);
        Map<Long, List<AttachReq>> attachReqDataMap = this.formatter.toAttachReqDataMap(rawAttachReq);
        Collection<ProjectData> projectDataList = this.formatter.toProjectData(rawProjectData);
        Collection<FolderData> folderDataList = this.formatter.toFolderData(projectDataList, rawFolderData);
        Collection<TestCaseData> testCaseDataList = this.formatter.toTestCaseData(rawBoundTCData);
        Collection<CufData> cufDataList = this.formatter.toCufData(rawCufData);
        Collection<CufData> rtfCufDataList = this.formatter.toCufData(rawRtfCufData);
        Collection<CufData> numCufDataList = this.formatter.toCufData(numRtfCufData);
        Collection<CufData> tagCufDataList = this.formatter.toMultipleValueCufData(rawtagCufData);
        Collection<RequirementVersionData> versionDataList = this.formatter.toRequirementVersionData(rawReqVersionData);
        Collection<ReqLinkData> reqLinkDataList = this.formatter.toReqLinkData(rawreqLinkData);
        this.formatter.bindAllData(projectDataList, folderDataList, versionDataList, testCaseDataList, cufDataList, rtfCufDataList, numCufDataList, tagCufDataList, reqLinkDataList, attachReqDataMap);
        res.put("data", projectDataList);
        if (this.isMilestonePicker(crit)) {
            List milestoneIds = (List)crit.get(MILESTONES).getValue();
            String milestoneLabel = this.queryFinder.getMilestoneLabel((Integer)milestoneIds.get(0));
            res.put("milestoneLabel", milestoneLabel);
        }
    }

    public void setIdsByProjectQuery(Resource idsByProjectQuery) {
        String query = this.loadQuery(idsByProjectQuery);
        this.queryFinder.setIdsByProjectQuery(query);
    }

    public void setLastVersionIdsByProjectQuery(Resource lastVersionIdsByProjectQuery) {
        String query = this.loadQuery(lastVersionIdsByProjectQuery);
        this.queryFinder.setLastVersionIdsByProjectQuery(query);
    }

    public void setIdsByTagQuery(Resource idsByTagQuery) {
        String query = this.loadQuery(idsByTagQuery);
        this.queryFinder.setIdsByTagQuery(query);
    }

    public void setLastVersionIdsByTagQuery(Resource lastVersionIdsByTagQuery) {
        String query = this.loadQuery(lastVersionIdsByTagQuery);
        this.queryFinder.setLastVersionIdsByTagQuery(query);
    }

    public void setIdsBySelectionQuery(Resource idsBySelectionQuery) {
        String query = this.loadQuery(idsBySelectionQuery);
        this.queryFinder.setIdsBySelectionQuery(query);
    }

    public void setLastVersionIdsBySelectionQuery(Resource lastVersionIdsBySelectionQuery) {
        String query = this.loadQuery(lastVersionIdsBySelectionQuery);
        this.queryFinder.setLastVersionIdsBySelectionQuery(query);
    }

    public void setRequirementVersionDataQuery(Resource requirementVersionDataQuery) {
        String query = this.loadQuery(requirementVersionDataQuery);
        this.queryFinder.setRequirementVersionDataQuery(query);
    }

    public void setFolderDataQuery(Resource folderDataQuery) {
        String query = this.loadQuery(folderDataQuery);
        this.queryFinder.setFolderDataQuery(query);
    }

    public void setProjectDataQuery(Resource projectDataQuery) {
        String query = this.loadQuery(projectDataQuery);
        this.queryFinder.setProjectDataQuery(query);
    }

    public void setBoundTCDataQuery(Resource boundTCDataQuery) {
        String query = this.loadQuery(boundTCDataQuery);
        this.queryFinder.setBoundTCDataQuery(query);
    }

    public void setCufsDataQuery(Resource cufsDataQuery) {
        String query = this.loadQuery(cufsDataQuery);
        this.queryFinder.setCufsDataQuery(query);
    }

    public void setRtfCufsDataQuery(Resource rtfCufsDataQuery) {
        String query = this.loadQuery(rtfCufsDataQuery);
        this.queryFinder.setRtfCufsDataQuery(query);
    }

    public void setTagCufsDataQuery(Resource tagCufsDataQuery) {
        String query = this.loadQuery(tagCufsDataQuery);
        this.queryFinder.setTagCufsDataQuery(query);
    }

    public void setNumCufsDataQuery(Resource numCufsDataQuery) {
        String query = this.loadQuery(numCufsDataQuery);
        this.queryFinder.setNumCufsDataQuery(query);
    }

    public void setIdsByMilestoneQuery(Resource idsByMilestoneQuery) {
        String query = this.loadQuery(idsByMilestoneQuery);
        this.queryFinder.setIdsByMilestoneQuery(query);
    }

    public void setLastVersionIdsByMilestoneQuery(Resource lastVersionIdsByMilestoneQuery) {
        String query = this.loadQuery(lastVersionIdsByMilestoneQuery);
        this.queryFinder.setLastVersionIdsByMilestoneQuery(query);
    }

    public void setReqLinkDataQuery(Resource reqLinkDataQuery) {
        String query = this.loadQuery(reqLinkDataQuery);
        this.queryFinder.setReqLinkDataQuery(query);
    }

    public void setAttachReqDataQuery(Resource attachReqDataQuery) {
        String query = this.loadQuery(attachReqDataQuery);
        this.queryFinder.setAttachReqDataQuery(query);
    }

    public void setNodeIdsQuery(Resource nodeIdsQuery) {
        String query = this.loadQuery(nodeIdsQuery);
        this.queryFinder.setNodeIdsQuery(query);
    }

    protected SqlQueryRunner getRunner() {
        return this.runner;
    }

    private Collection<Long> getReqVersionIdList(Map<String, Criteria> criteriaMap) {
        Collection<Long> requirementIdList;
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        Criteria options = criteriaMap.get("reportOptions");
        optionsMap.put("printOnlyLastVersion", false);
        Collection selectedOptions = (Collection)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        Boolean printOnlyLastVersion = (Boolean)optionsMap.get("printOnlyLastVersion");
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        if ("PROJECT_PICKER".equals(selectionMode.getValue())) {
            Criteria criteria = criteriaMap.get(PROJECT_IDS);
            List<Long> projectIds = ((List)criteria.getValue()).stream().map(Long::valueOf).toList();
            readableProjectIds.retainAll(projectIds);
            requirementIdList = this.queryFinder.findIdsByProject(readableProjectIds, printOnlyLastVersion);
        } else if ("MILESTONE_PICKER".equals(selectionMode.getValue())) {
            List milestoneIds = (List)criteriaMap.get(MILESTONES).getValue();
            requirementIdList = this.queryFinder.findIdsByMilestone(milestoneIds, printOnlyLastVersion, readableProjectIds);
        } else if ("TAG_PICKER".equals(selectionMode.getValue())) {
            List tags = (List)criteriaMap.get(TAGS).getValue();
            requirementIdList = this.queryFinder.findIdsByTags(tags, printOnlyLastVersion, readableProjectIds);
        } else {
            ArrayList folderIds;
            Collection highLvlReqIds;
            Criteria criteria = criteriaMap.get(REQUIREMENTS_IDS);
            Map selectedIds = (Map)criteria.getValue();
            ArrayList<String> allStrIds = (ArrayList<String>)selectedIds.get(REQUIREMENTS);
            if (allStrIds == null) {
                allStrIds = new ArrayList<String>();
            }
            if ((highLvlReqIds = (Collection)selectedIds.get(HIGH_LEVEL_REQUIREMENTS)) != null && !highLvlReqIds.isEmpty()) {
                allStrIds.addAll(highLvlReqIds);
            }
            if ((folderIds = (ArrayList)selectedIds.get(REQUIREMENT_FOLDERS)) == null) {
                folderIds = new ArrayList();
            }
            allStrIds.addAll(folderIds);
            requirementIdList = this.queryFinder.findIdsBySelection(allStrIds, printOnlyLastVersion, readableProjectIds);
        }
        return requirementIdList;
    }

    private boolean isMilestonePicker(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(REQUIREMENTS_SELECTION_MODE);
        return "MILESTONE_PICKER".equals(selectionMode.getValue());
    }

    protected String loadQuery(Resource query) {
        InputStream is;
        try {
            is = query.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
    }
}

