SELECT p.NAME,
p.DESCRIPTION,
p.TEST_CASE_ID,
'' AS TEST_CASE_SOURCE,
'' AS REFERENCE,
'' AS PROJECT_NAME
FROM PARAMETER p
WHERE p.TEST_CASE_ID IN (:testcaseIds)
UNION
SELECT
p.NAME,
p.DESCRIPTION,
tc.TCLN_ID,
tcln.NAME AS TEST_CASE_SOURCE,
tcc.REFERENCE,
proj.NAME AS PROJECT_NAME
FROM PARAMETER p
INNER JOIN CALL_TEST_STEP cts ON p.TEST_CASE_ID = cts.CALLED_TEST_CASE_ID
INNER JOIN TEST_CASE tcc ON tcc.TCLN_ID = cts.CALLED_TEST_CASE_ID
INNER JOIN TEST_CASE_LIBRARY_NODE tcln ON tcc.TCLN_ID = tcln.TCLN_ID
INNER JOIN PROJECT proj ON proj.PROJECT_ID = tcln.PROJECT_ID
INNER JOIN TEST_CASE_STEPS tcs ON cts.TEST_STEP_ID = tcs.STEP_ID
INNER JOIN TEST_CASE tc ON tcs.TEST_CASE_ID = tc.TCLN_ID
WHERE tc.TCLN_ID IN (:testcaseIds) and cts.DELEGATE_PARAMETER_VALUES is true
