select FOLDER.RLN_ID as FOLDER_ID, 
	PARENT_REQ.CURRENT_VERSION_ID as PARENT_CUR_VERSION_ID, 
	RLN.PROJECT_ID, 
	VERSION.RES_ID, 
	VERSION.REQUIREMENT_ID, 
	VERSION.REFERENCE, 
	VERSION.VERSION_NUMBER, 
	VERSION.CRITICALITY, 
	VERSION.REQUIREMENT_STATUS, 
	MAX(CATEGORY.LABEL) as catLabel, 
	MAX(CATEGORY.ITEM_TYPE) as catItemType, 
	COUNT(ATTACH.ATTACHMENT_ID), 
	RES.NAME, 
	RES.DESCRIPTION, 
	RES.CREATED_BY, 
	RES.CREATED_ON, 
	RES.LAST_MODIFIED_BY, 
	RES.LAST_MODIFIED_ON, 
	LAST_VERSION.VERSION_NUMBER AS TOTAL_VERSION,
	COALESCE(GROUP_CONCAT(MSTONE.LABEL), '') as MILESTONES
from REQUIREMENT_VERSION VERSION 
left join MILESTONE_REQ_VERSION REQSTONES on VERSION.RES_ID = REQSTONES.REQ_VERSION_ID 
left join MILESTONE MSTONE on REQSTONES.MILESTONE_ID = MSTONE.MILESTONE_ID 
inner join REQUIREMENT REQ on REQ.RLN_ID = VERSION.REQUIREMENT_ID 
inner join REQUIREMENT_VERSION LAST_VERSION on REQ.CURRENT_VERSION_ID = LAST_VERSION.RES_ID 
inner join REQUIREMENT_LIBRARY_NODE RLN on RLN.RLN_ID = VERSION.REQUIREMENT_ID 
left join RLN_RELATIONSHIP RLNP on RLNP.DESCENDANT_ID = RLN.RLN_ID 
left join REQUIREMENT_FOLDER FOLDER on FOLDER.RLN_ID = RLNP.ANCESTOR_ID
inner join RESOURCE RES on RES.RES_ID = VERSION.RES_ID 
left join ATTACHMENT ATTACH on ATTACH.ATTACHMENT_LIST_ID = RES.ATTACHMENT_LIST_ID 
left join RLN_RELATIONSHIP REQ_HIERARCHY on REQ_HIERARCHY.DESCENDANT_ID = REQ.RLN_ID
left join REQUIREMENT PARENT_REQ on REQ_HIERARCHY.ANCESTOR_ID = PARENT_REQ.RLN_ID
left join INFO_LIST_ITEM CATEGORY on CATEGORY.ITEM_ID = VERSION.CATEGORY
where VERSION.RES_ID in (:versionIds) 
group by VERSION.REQUIREMENT_ID, 
	VERSION.RES_ID, 
	FOLDER.RLN_ID, 
	PARENT_CUR_VERSION_ID, 
	RLN.PROJECT_ID, 
	RES.NAME, 
	RES.DESCRIPTION, 
	RES.CREATED_BY, 
	RES.CREATED_ON, 
	RES.LAST_MODIFIED_BY, 
	RES.LAST_MODIFIED_ON, 
	TOTAL_VERSION 
order by VERSION.VERSION_NUMBER asc 