/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.requirements.query;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.AttachReq;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.CufData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.FolderData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.ProjectData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.ReqLinkData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.RequirementVersionData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.TestCaseData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.query.RequirementTreeQueryFinder;

public class RequirementTreeQueryFormatter {
    private static final String END_SEPARATOR_PLACEHOLDER = "=Sep=";
    private static final String TAG_SEPARATOR = "|";
    private static final String SEPARATOR_PLACEHOLDER = "=Sep=,";
    private static final String REQLINK_RELATED = "requirement-version.link.type.related";
    private static final String REQLINK_PARENT = "requirement-version.link.type.parent";
    private static final String REQLINK_CHILD = "requirement-version.link.type.child";
    private static final String REQLINK_DUPLICATE = "requirement-version.link.type.duplicate";
    private RequirementTreeQueryFinder queryFinder;

    public void setQueryFinder(RequirementTreeQueryFinder queryFinder) {
        this.queryFinder = queryFinder;
    }

    Collection<ProjectData> toProjectData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        ArrayList<ProjectData> result = new ArrayList<ProjectData>(tuples.size());
        for (Object[] array : tuples) {
            ProjectData newData = new ProjectData();
            Long id = konvertor.from(array[0]).toLong();
            String name = konvertor.from(array[1]).toString();
            newData.setId(id);
            newData.setName(name);
            result.add(newData);
        }
        return result;
    }

    Collection<FolderData> toFolderData(Collection<ProjectData> projects, Collection<Object[]> tuples) {
        FolderData newData;
        Konvertor konvertor = new Konvertor();
        ArrayList<FolderData> result = new ArrayList<FolderData>();
        for (Object[] array : tuples) {
            newData = new FolderData();
            Long ancestorId = konvertor.from(array[0]).toLong();
            Long folderId = konvertor.from(array[1]).toLong();
            Long projectId = konvertor.from(array[2]).toLong();
            String name = konvertor.from(array[3]).toString();
            String description = konvertor.from(array[4]).toString();
            newData.setAncestorId(ancestorId);
            newData.setFolderId(folderId);
            newData.setProjectId(projectId);
            newData.setName(name);
            newData.setDescription(description);
            result.add(newData);
        }
        for (ProjectData project : projects) {
            newData = new FolderData();
            newData.setProjectId(project.getId());
            newData.setPseudoRoot(true);
            result.add(newData);
        }
        return result;
    }

    Collection<TestCaseData> toTestCaseData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        ArrayList<TestCaseData> result = new ArrayList<TestCaseData>();
        for (Object[] array : tuples) {
            TestCaseData data = new TestCaseData();
            String projectName = konvertor.from(array[0]).toString();
            String testCaseName = konvertor.from(array[1]).toString();
            String importance = konvertor.from(array[2]).toString();
            Long requirementVersionId = konvertor.from(array[3]).toLong();
            String reference = konvertor.from(array[4]).toString();
            data.setProjectName(projectName);
            data.setName(testCaseName);
            data.setImportance(importance);
            data.setRequirementVersionId(requirementVersionId);
            data.setReference(reference);
            result.add(data);
        }
        return result;
    }

    Collection<CufData> toCufData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        ArrayList<CufData> result = new ArrayList<CufData>();
        for (Object[] array : tuples) {
            CufData data = new CufData();
            String cufValue = konvertor.from(array[0]).toString();
            String cufLabel = konvertor.from(array[1]).toString();
            String cufType = konvertor.from(array[2]).toString();
            Long reqVersionId = konvertor.from(array[3]).toLong();
            data.setLabel(cufLabel);
            data.setReqVersionId(reqVersionId);
            data.setType(cufType);
            data.setValue(cufValue);
            result.add(data);
        }
        return result;
    }

    Collection<RequirementVersionData> toRequirementVersionData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        LinkedList<RequirementVersionData> result = new LinkedList<RequirementVersionData>();
        for (Object[] array : tuples) {
            RequirementVersionData newData = new RequirementVersionData();
            Long folderId = konvertor.from(array[0]).toLong();
            Long parentReqVersionId = konvertor.from(array[1]).toLong();
            Long projectId = konvertor.from(array[2]).toLong();
            Long versionId = konvertor.from(array[3]).toLong();
            Long requirementId = konvertor.from(array[4]).toLong();
            String reference = konvertor.from(array[5]).toString();
            int versionNumber = konvertor.from(array[6]).toInt();
            String criticality = konvertor.from(array[7]).toString();
            String status = konvertor.from(array[8]).toString();
            String category = konvertor.from(array[9]).toString();
            String categoryType = konvertor.from(array[10]).toString();
            int nbAttachs = konvertor.from(array[11]).toInt();
            String name = konvertor.from(array[12]).toString();
            String description = konvertor.from(array[13]).toString();
            String createdBy = konvertor.from(array[14]).toString();
            Date createdOn = konvertor.from(array[15]).toDate();
            String modifiedBy = konvertor.from(array[16]).toString();
            Date modifiedOn = konvertor.from(array[17]).toDate();
            Integer totalVersionNumber = konvertor.from(array[18]).toInt();
            String milestoneLabels = konvertor.from(array[19]).toString();
            newData.setParentFolderId(folderId);
            newData.setParentReqVersionId(parentReqVersionId);
            newData.setProjectId(projectId);
            newData.setVersionId(versionId);
            newData.setRequirementId(requirementId);
            newData.setReference(reference);
            newData.setVersionNumber(versionNumber);
            newData.setCriticality(criticality);
            newData.setStatus(status);
            newData.setCategory(category);
            newData.setCategoryType(categoryType);
            newData.setNbAttachments(nbAttachs);
            newData.setName(name);
            newData.setDescription(description);
            newData.setCreatedBy(createdBy);
            newData.setCreatedOn(createdOn);
            newData.setModifiedBy(modifiedBy);
            newData.setModifiedOn(modifiedOn);
            newData.setTotalVersionNumber(totalVersionNumber);
            newData.setMilestoneLabels(milestoneLabels);
            result.add(newData);
        }
        return result;
    }

    Collection<ReqLinkData> toReqLinkData(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        ArrayList<ReqLinkData> result = new ArrayList<ReqLinkData>();
        for (Object[] array : tuples) {
            ReqLinkData data = new ReqLinkData();
            Long reqVersionId = konvertor.from(array[0]).toLong();
            Boolean direction = konvertor.from(array[1]).toBoolean();
            String role1 = konvertor.from(array[2]).toString();
            String role2 = konvertor.from(array[3]).toString();
            String project = konvertor.from(array[4]).toString();
            String name = konvertor.from(array[5]).toString();
            Long versionNumber = konvertor.from(array[6]).toLong();
            data.setName(name);
            data.setProject(project);
            data.setReqVersionId(reqVersionId);
            data.setVersionNumber(versionNumber);
            if (direction.booleanValue()) {
                data.setRole(role1);
            } else {
                data.setRole(role2);
            }
            result.add(data);
        }
        return result;
    }

    void bindAllData(Collection<ProjectData> projects, Collection<FolderData> folders, Collection<RequirementVersionData> versionData, Collection<TestCaseData> tcData, Collection<CufData> cufData, Collection<CufData> rtfCufData, Collection<CufData> numCufData, Collection<CufData> tagCufData, Collection<ReqLinkData> reqLinkData, Map<Long, List<AttachReq>> attachReqDataMap) {
        if (!versionData.isEmpty()) {
            this.bindTestCases(versionData, tcData);
            this.bindCufDatas(versionData, cufData);
            this.bindReqLinkDatas(versionData, reqLinkData);
            this.bindRtfCufDatas(versionData, rtfCufData);
            this.bindNumCufDatas(versionData, numCufData);
            this.bindTagCufDatas(versionData, tagCufData);
            this.bindAttachReqToReq(versionData, attachReqDataMap);
            this.bindRequirements(folders, versionData);
        }
        this.buildFolderHierarchy(folders);
        this.bindFolders(projects, folders);
    }

    public void bindAttachReqToReq(Collection<RequirementVersionData> requirements, Map<Long, List<AttachReq>> attachReqDataMap) {
        for (RequirementVersionData req : requirements) {
            req.setAttachReqs(attachReqDataMap.get(req.getRequirementId()));
        }
    }

    private void bindTagCufDatas(Collection<RequirementVersionData> versionData, Collection<CufData> tagCufData) {
        for (RequirementVersionData version : versionData) {
            List<CufData> cufs = this.groupCufsForRequirement(tagCufData, version);
            version.setTagCufs(cufs);
        }
    }

    private void bindTestCases(Collection<RequirementVersionData> versionData, Collection<TestCaseData> testCaseData) {
        for (RequirementVersionData version : versionData) {
            Iterator<TestCaseData> iterator = testCaseData.iterator();
            while (iterator.hasNext()) {
                TestCaseData next = iterator.next();
                if (!version.acceptsAsContent(next)) continue;
                version.addTestCase(next);
                iterator.remove();
            }
            version.sortContent();
        }
    }

    private void bindCufDatas(Collection<RequirementVersionData> versionData, Collection<CufData> cufData) {
        for (RequirementVersionData version : versionData) {
            List<CufData> cufs = this.groupCufsForRequirement(cufData, version);
            version.setCufs(cufs);
        }
    }

    private void bindRtfCufDatas(Collection<RequirementVersionData> versionData, Collection<CufData> rtfCufData) {
        for (RequirementVersionData version : versionData) {
            List<CufData> cufs = this.groupCufsForRequirement(rtfCufData, version);
            version.setRtfCufs(cufs);
        }
    }

    private void bindReqLinkDatas(Collection<RequirementVersionData> versionData, Collection<ReqLinkData> reqLinkData) {
        for (RequirementVersionData version : versionData) {
            List<ReqLinkData> reqLinks = this.groupReqLinkForRequirement(reqLinkData, version);
            version.setReqLinks(reqLinks);
        }
    }

    private void bindNumCufDatas(Collection<RequirementVersionData> versionData, Collection<CufData> numCufData) {
        for (RequirementVersionData version : versionData) {
            List<CufData> cufs = this.groupCufsForRequirement(numCufData, version);
            version.setNumCufs(cufs);
        }
    }

    public List<CufData> groupCufsForRequirement(Collection<CufData> cufData, RequirementVersionData version) {
        Iterator<CufData> iterator = cufData.iterator();
        ArrayList<CufData> cufs = new ArrayList<CufData>();
        while (iterator.hasNext()) {
            CufData next = iterator.next();
            if (!version.acceptsAsCuf(next)) continue;
            cufs.add(next);
            iterator.remove();
        }
        return cufs;
    }

    private void bindRequirements(Collection<FolderData> folderData, Collection<RequirementVersionData> versionData) {
        HashMap<Long, RequirementVersionData> mappedVersions = new HashMap<Long, RequirementVersionData>(versionData.size());
        for (RequirementVersionData vData : versionData) {
            mappedVersions.put(vData.getVersionId(), vData);
        }
        for (RequirementVersionData vData : mappedVersions.values()) {
            if (!vData.hasParentRequirementVersion()) continue;
            RequirementVersionData parent = (RequirementVersionData)mappedVersions.get(vData.getParentReqVersionId());
            if (parent != null) {
                parent.addChildrenRequirement(vData);
                continue;
            }
            vData = this.verifyRootFolder(vData);
            vData.setParentRequirementVersion(null);
            vData.setParentReqVersionId(null);
        }
        for (FolderData folder : folderData) {
            Iterator<RequirementVersionData> iterator = versionData.iterator();
            while (iterator.hasNext()) {
                RequirementVersionData version = iterator.next();
                if (!folder.acceptsAsContent(version)) continue;
                folder.addContent(version);
                iterator.remove();
            }
        }
    }

    private void buildFolderHierarchy(Collection<FolderData> data) {
        if (data.isEmpty()) {
            return;
        }
        LinkedList<FolderData> nonTreatedFolders = new LinkedList<FolderData>();
        nonTreatedFolders.addAll(data);
        LinkedList<FolderData> beingProcessed = this._findPseudoRoot(data);
        FolderData underProcess = beingProcessed.removeFirst();
        while (underProcess != null) {
            Iterator iterator = nonTreatedFolders.iterator();
            while (iterator.hasNext()) {
                FolderData folder = (FolderData)iterator.next();
                if (folder == underProcess) {
                    iterator.remove();
                    continue;
                }
                if (!underProcess.acceptsAsContent(folder)) continue;
                folder.setParent(underProcess);
                underProcess.addContent(folder);
                beingProcessed.add(folder);
                iterator.remove();
            }
            underProcess.sortContent();
            FolderData folderData = underProcess = beingProcessed.isEmpty() ? null : beingProcessed.removeFirst();
        }
    }

    private void bindFolders(Collection<ProjectData> projects, Collection<FolderData> folders) {
        for (ProjectData project : projects) {
            for (FolderData folder : folders) {
                if (!project.acceptsAsContent(folder)) continue;
                project.addFolder(folder);
            }
        }
    }

    private LinkedList<FolderData> _findPseudoRoot(Collection<FolderData> data) {
        LinkedList<FolderData> pseudoRoots = new LinkedList<FolderData>();
        for (FolderData folder : data) {
            if (!folder.isPseudoRoot()) continue;
            pseudoRoots.add(folder);
        }
        return pseudoRoots;
    }

    private List<ReqLinkData> groupReqLinkForRequirement(Collection<ReqLinkData> reqLinkData, RequirementVersionData version) {
        Iterator<ReqLinkData> iterator = reqLinkData.iterator();
        ArrayList<ReqLinkData> reqLinks = new ArrayList<ReqLinkData>();
        while (iterator.hasNext()) {
            ReqLinkData next = iterator.next();
            if (!version.acceptsAsReqLink(next)) continue;
            reqLinks.add(next);
            iterator.remove();
        }
        return reqLinks;
    }

    public Collection<CufData> toMultipleValueCufData(Collection<Object[]> tuples) {
        Collection<CufData> cufData = this.toCufData(tuples);
        for (CufData cuf : cufData) {
            String cufValue = cuf.getValue();
            cufValue = cufValue.replaceAll(SEPARATOR_PLACEHOLDER, TAG_SEPARATOR);
            cufValue = cufValue.substring(0, cufValue.length() - END_SEPARATOR_PLACEHOLDER.length());
            cuf.setValue(cufValue);
        }
        return cufData;
    }

    private RequirementVersionData verifyRootFolder(RequirementVersionData data) {
        RequirementVersionData tempData = data;
        if (tempData.getParentReqVersionId() != null) {
            while (tempData.hasParentRequirementVersion()) {
                List<Long> versionIds = Arrays.asList(tempData.getParentReqVersionId());
                Collection<Object[]> rawReqVersionData = this.queryFinder.getReqVersionsDataForVersionIds(versionIds);
                tempData = this.toRequirementVersionData(rawReqVersionData).iterator().next();
            }
        }
        data.setParentFolderId(tempData.getParentFolderId());
        return data;
    }

    Map<Long, List<AttachReq>> toAttachReqDataMap(Collection<Object[]> tuples) {
        Konvertor konvertor = new Konvertor();
        HashMap result = new HashMap();
        for (Object[] array : tuples) {
            AttachReq data = new AttachReq();
            data.setReference(konvertor.from(array[2]).toString());
            data.setName(konvertor.from(array[3]).toString());
            data.setMilestones(konvertor.from(array[4]).toString());
            data.setCriticality(konvertor.from(array[5]).toString());
            data.setParent(konvertor.from(array[6]).toLong());
            RequirementTreeQueryFormatter.addToMap(konvertor.from(array[0]).toLong(), data, result);
        }
        return result;
    }

    static <T> void addToMap(Long key, T data, Map<Long, List<T>> result) {
        if (result.containsKey(key)) {
            result.get(key).add(data);
        } else {
            result.put(key, new ArrayList<T>(Collections.singletonList(data)));
        }
    }

    private class Konvertor {
        private Object object;

        private Konvertor() {
        }

        Konvertor from(Object toConvert) {
            this.object = toConvert;
            return this;
        }

        public String toString() {
            if (this.object == null) {
                return null;
            }
            return this.object.toString();
        }

        public Long toLong() {
            if (this.object == null) {
                return null;
            }
            Object object = this.object;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, BigInteger.class, Long.class, Integer.class, Timestamp.class, Date.class, Instant.class}, (Object)object2, n)) {
                case 0 -> {
                    String ignored = (String)object2;
                    yield Long.valueOf((String)this.object);
                }
                case 1 -> {
                    BigInteger ignored = (BigInteger)object2;
                    yield ((BigInteger)this.object).longValue();
                }
                case 2 -> {
                    Long ignored = (Long)object2;
                    yield (Long)this.object;
                }
                case 3 -> {
                    Integer ignored = (Integer)object2;
                    yield ((Integer)this.object).longValue();
                }
                case 4 -> {
                    Timestamp ignored = (Timestamp)object2;
                    yield ((Timestamp)this.object).getTime();
                }
                case 5 -> {
                    Date ignored = (Date)object2;
                    yield ((Date)this.object).getTime();
                }
                case 6 -> {
                    Instant ignored = (Instant)object2;
                    yield Timestamp.from((Instant)this.object).getTime();
                }
                default -> Long.valueOf(this.object.toString());
            };
        }

        public Date toDate() {
            if (this.object == null) {
                return null;
            }
            Class<?> clazz = this.object.getClass();
            Date result = clazz.equals(Date.class) ? (Date)this.object : new Date(this.toLong());
            return result;
        }

        public Integer toInt() {
            if (this.object == null) {
                return null;
            }
            Class<?> clazz = this.object.getClass();
            Integer result = clazz.equals(Integer.class) ? (Integer)this.object : Integer.valueOf(this.toString());
            return result;
        }

        public Boolean toBoolean() {
            if (this.object == null) {
                return null;
            }
            Class<?> clazz = this.object.getClass();
            Boolean result = null;
            if (clazz.equals(String.class)) {
                result = Boolean.valueOf((String)this.object);
            } else if (clazz.equals(Boolean.class)) {
                result = (Boolean)this.object;
            }
            return result;
        }
    }
}

