/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.requirements.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.api.repository.SqlQueryRunner;

public class RequirementTreeQueryFinder {
    private static final String VERSION_IDS = "versionIds";
    private static final String REQUIREMENT_IDS = "requirementIds";
    private static final String PROJECT_IDS = "projectIds";
    private static final String SQL_FIND_MILESTONE_LABEL = "select label from MILESTONE where milestone_id = :milestoneId";
    private String idsByProjectQuery;
    private String lastVersionIdsByProjectQuery;
    private String idsBySelectionQuery;
    private String lastVersionIdsBySelectionQuery;
    private String idsByMilestoneQuery;
    private String lastVersionIdsByMilestoneQuery;
    private String requirementVersionDataQuery;
    private String folderDataQuery;
    private String projectDataQuery;
    private String boundTCDataQuery;
    private String cufsDataQuery;
    private String rtfCufsDataQuery;
    private String tagCufsDataQuery;
    private String numCufsDataQuery;
    private String idsByTagQuery;
    private String lastVersionIdsByTagQuery;
    private String reqLinkDataQuery;
    private String attachReqDataQuery;
    private String nodeIdsQuery;
    protected SqlQueryRunner runner;

    RequirementTreeQueryFinder() {
    }

    void setLastVersionIdsByTagQuery(String lastVersionIdsByTagQuery) {
        this.lastVersionIdsByTagQuery = lastVersionIdsByTagQuery;
    }

    void setLastVersionIdsBySelectionQuery(String lastVersionIdsBySelectionQuery) {
        this.lastVersionIdsBySelectionQuery = lastVersionIdsBySelectionQuery;
    }

    void setLastVersionIdsByMilestoneQuery(String lastVersionIdsByMilestoneQuery) {
        this.lastVersionIdsByMilestoneQuery = lastVersionIdsByMilestoneQuery;
    }

    void setLastVersionIdsByProjectQuery(String lastVersionIdsByProjectQuery) {
        this.lastVersionIdsByProjectQuery = lastVersionIdsByProjectQuery;
    }

    void setIdsByProjectQuery(String idsByProjectQuery) {
        this.idsByProjectQuery = idsByProjectQuery;
    }

    void setIdsBySelectionQuery(String idsBySelectionQuery) {
        this.idsBySelectionQuery = idsBySelectionQuery;
    }

    void setIdsByMilestoneQuery(String idsByMilestoneQuery) {
        this.idsByMilestoneQuery = idsByMilestoneQuery;
    }

    void setRequirementVersionDataQuery(String requirementVersionDataQuery) {
        this.requirementVersionDataQuery = requirementVersionDataQuery;
    }

    void setFolderDataQuery(String folderDataQuery) {
        this.folderDataQuery = folderDataQuery;
    }

    void setProjectDataQuery(String projectDataQuery) {
        this.projectDataQuery = projectDataQuery;
    }

    void setBoundTCDataQuery(String boundTCDataQuery) {
        this.boundTCDataQuery = boundTCDataQuery;
    }

    public void setCufsDataQuery(String cufsDataQuery) {
        this.cufsDataQuery = cufsDataQuery;
    }

    public void setRtfCufsDataQuery(String rtfCufsDataQuery) {
        this.rtfCufsDataQuery = rtfCufsDataQuery;
    }

    public void setTagCufsDataQuery(String tagCufsDataQuery) {
        this.tagCufsDataQuery = tagCufsDataQuery;
    }

    public void setNumCufsDataQuery(String numCufsDataQuery) {
        this.numCufsDataQuery = numCufsDataQuery;
    }

    public void setIdsByTagQuery(String idsByTagQuery) {
        this.idsByTagQuery = idsByTagQuery;
    }

    public void setReqLinkDataQuery(String reqLinkDataQuery) {
        this.reqLinkDataQuery = reqLinkDataQuery;
    }

    public void setAttachReqDataQuery(String attachReqDataQuery) {
        this.attachReqDataQuery = attachReqDataQuery;
    }

    public void setNodeIdsQuery(String nodeIdsQuery) {
        this.nodeIdsQuery = nodeIdsQuery;
    }

    void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    Collection<Long> findIdsByProject(List<Long> projectIds, Boolean printOnlyLastVersion) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(1);
        params.put(PROJECT_IDS, projectIds);
        String query = printOnlyLastVersion != false ? this.lastVersionIdsByProjectQuery : this.idsByProjectQuery;
        List foundStrIds = this.runner.executeSelect(query, params);
        return this.toIdList(foundStrIds);
    }

    Collection<Long> findIdsBySelection(Collection<String> ids, Boolean printOnlyLastVersion, List<Long> projectIds) {
        LinkedList<Long> versionIds = new LinkedList();
        if (ids != null && !ids.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
            params.put("nodeIds", this.toIdList(ids));
            params.put(PROJECT_IDS, projectIds);
            String query = printOnlyLastVersion != false ? this.lastVersionIdsBySelectionQuery : this.idsBySelectionQuery;
            List foundStrIds = this.runner.executeSelect(query, params);
            versionIds.addAll(this.toIdList(foundStrIds));
        } else {
            versionIds = new ArrayList();
        }
        return versionIds;
    }

    Collection<Long> findIdsByMilestone(Collection<String> milestoneIds, Boolean printOnlyLastVersion, List<Long> projectIds) {
        if (!milestoneIds.isEmpty()) {
            HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
            params.put("milestones", this.toIdList(milestoneIds));
            params.put(PROJECT_IDS, projectIds);
            String query = printOnlyLastVersion != false ? this.lastVersionIdsByMilestoneQuery : this.idsByMilestoneQuery;
            List foundIds = this.runner.executeSelect(query, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    public Collection<Long> findIdsByTags(List<String> tags, Boolean printOnlyLastVersion, List<Long> projectIds) {
        if (!tags.isEmpty()) {
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            params.put("tags", tags);
            params.put(PROJECT_IDS, projectIds);
            String query = printOnlyLastVersion != false ? this.lastVersionIdsByTagQuery : this.idsByTagQuery;
            List foundIds = this.runner.executeSelect(query, params);
            return this.toIdList(foundIds);
        }
        return Collections.emptyList();
    }

    public Collection<Long> findIdsByVersions(Collection<Long> versionIds) {
        if (CollectionUtils.isEmpty(versionIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put(VERSION_IDS, versionIds);
        List foundStrIds = this.runner.executeSelect(this.nodeIdsQuery, params);
        return this.toIdList(foundStrIds);
    }

    Collection<Object[]> getReqVersionsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.requirementVersionDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getTestCasesDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.boundTCDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.cufsDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getRtfCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.rtfCufsDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getNumCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.numCufsDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getFoldersDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.folderDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getProjectDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.projectDataQuery, VERSION_IDS, requirementIds);
    }

    public Collection<Object[]> getreqLinkDataQueryForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.reqLinkDataQuery, VERSION_IDS, requirementIds);
    }

    Collection<Object[]> getAttachReqForReqIds(Collection<Long> requirementIds) {
        return this.execute(this.attachReqDataQuery, REQUIREMENT_IDS, requirementIds);
    }

    String getMilestoneLabel(Integer milestoneId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("milestoneId", milestoneId);
        return (String)this.runner.executeUniqueSelect(SQL_FIND_MILESTONE_LABEL, params);
    }

    private Collection<Object[]> execute(String query, String paramName, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>(1);
        params.put(paramName, ids);
        return this.runner.executeSelect(query, params);
    }

    protected Collection<Long> toIdList(Collection<?> ids) {
        return CollectionUtils.collect(ids, (Transformer)new IdTransformer());
    }

    public Collection<Object[]> getTagCufsDataForVersionIds(Collection<Long> requirementIds) {
        return this.execute(this.tagCufsDataQuery, VERSION_IDS, requirementIds);
    }

    private static class IdTransformer
    implements Transformer {
        private IdTransformer() {
        }

        public Object transform(Object arg0) {
            String className;
            if (arg0 == null) {
                throw new IllegalArgumentException("ID cannot be null");
            }
            return switch (className = arg0.getClass().getName()) {
                case "java.lang.String" -> Long.valueOf((String)arg0);
                case "java.math.BigInteger" -> ((BigInteger)arg0).longValue();
                case "java.lang.Integer" -> (long)((Integer)arg0).intValue();
                case "java.lang.Long" -> arg0;
                default -> throw new IllegalArgumentException("IdTransformer cannot convert items of class %s".formatted(className));
            };
        }
    }
}

